/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ExtensionParsingContextImpl;
import org.jboss.as.controller.parsing.JvmType;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class CommonXml
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<ModelMarshallingContext> {
    protected static final Set<String> RESTRICTED_PATHS;
    protected final ModuleLoader moduleLoader;

    protected CommonXml(ModuleLoader loader) {
        this.moduleLoader = loader;
    }

    protected String getDefaultName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to determine a default name based on the local host name", e);
        }
    }

    protected void parseNamespaces(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) {
        int namespaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null || prefix.length() <= 0) continue;
            ModelNode operation = new ModelNode();
            operation.get("address").set(address);
            operation.get("operation").set("add-namespace");
            operation.get("namespace").set(prefix, reader.getNamespaceURI(i));
            nodes.add(operation);
        }
    }

    protected void readHeadComment(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) throws XMLStreamException {
    }

    protected void readTailComment(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) throws XMLStreamException {
    }

    protected void parseSchemaLocations(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updateList, int idx) throws XMLStreamException {
        List values = reader.getListAttributeValue(idx);
        if ((values.size() & 1) != 0) {
            throw ParseUtils.invalidAttributeValue(reader, idx);
        }
        Iterator it = values.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String val = (String)it.next();
            if (key.length() <= 0 || val.length() <= 0) continue;
            ModelNode update = new ModelNode();
            update.get("address").set(address);
            update.get("operation").set("add-schema-location");
            update.get("schema-location").set(key, val);
            updateList.add(update);
        }
    }

    protected void writeSchemaLocation(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        StringBuilder b = new StringBuilder();
        Iterator iterator = modelNode.get("schema-locations").asList().iterator();
        while (iterator.hasNext()) {
            ModelNode location = (ModelNode)iterator.next();
            Property property = location.asProperty();
            b.append(property.getName()).append(' ').append(property.getValue().asString());
            if (!iterator.hasNext()) continue;
            b.append(' ');
        }
        if (b.length() > 0) {
            writer.writeAttribute(Namespace.XML_SCHEMA_INSTANCE.getUriString(), Attribute.SCHEMA_LOCATION.getLocalName(), b.toString());
        }
    }

    protected void writeNamespaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        for (Property property : modelNode.get("namespaces").asPropertyList()) {
            writer.writeNamespace(property.getName(), property.getValue().asString());
        }
    }

    protected void writeExtensions(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set keys = modelNode.keys();
        if (keys.size() > 0) {
            writer.writeStartElement(Element.EXTENSIONS.getLocalName());
            for (String extension : keys) {
                writer.writeEmptyElement(Element.EXTENSION.getLocalName());
                writer.writeAttribute(Attribute.MODULE.getLocalName(), extension);
            }
            writer.writeEndElement();
        }
    }

    protected void writePaths(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List paths = node.asPropertyList();
        if (paths.size() > 0) {
            writer.writeStartElement(Element.PATHS.getLocalName());
            for (Property path : paths) {
                ModelNode value = path.getValue();
                writer.writeEmptyElement(Element.PATH.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), path.getName());
                writer.writeAttribute(Attribute.PATH.getLocalName(), value.get("path").asString());
                if (!value.has("relative-to") || !value.get("relative-to").isDefined()) continue;
                writer.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), value.get("relative-to").asString());
            }
            writer.writeEndElement();
        }
    }

    protected void parseExtensions(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> found = new HashSet<String>();
        ExtensionParsingContextImpl context = new ExtensionParsingContextImpl(reader.getXMLMapper());
        while (reader.hasNext() && reader.nextTag() != 2) {
            String moduleName = ParseUtils.readStringAttributeElement(reader, Attribute.MODULE.getLocalName());
            if (!found.add(moduleName)) {
                throw ParseUtils.invalidAttributeValue(reader, 0);
            }
            try {
                Module module = this.moduleLoader.loadModule(ModuleIdentifier.fromString((String)moduleName));
                boolean initialized = false;
                for (Extension extension : module.loadService(Extension.class)) {
                    extension.initializeParsers(context);
                    if (initialized) continue;
                    initialized = true;
                }
                if (!initialized) {
                    throw new IllegalStateException("No META-INF/services/" + Extension.class.getName() + " found for " + module.getIdentifier());
                }
                ModelNode add = new ModelNode();
                add.get("address").set(address).add("extension", moduleName);
                add.get("operation").set("add");
                list.add(add);
            }
            catch (ModuleLoadException e) {
                throw new XMLStreamException("Failed to load module", e);
            }
        }
    }

    protected void parsePaths(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requirePath) throws XMLStreamException {
        HashSet<String> pathNames = new HashSet<String>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PATH: {
                            this.parsePath(reader, address, list, requirePath, pathNames);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseManagement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case NATIVE_INTERFACE: {
                            this.parseNativeManagementSocket(reader, address, list);
                            continue block7;
                        }
                        case HTTP_INTERFACE: {
                            this.parseHttpManagementSocket(reader, address, list);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parsePath(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requirePath, Set<String> defined) throws XMLStreamException {
        String name = null;
        String path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    if (RESTRICTED_PATHS.contains(value)) {
                        throw new XMLStreamException(name + " is reserved", reader.getLocation());
                    }
                    if (defined.add(name)) continue block5;
                    throw new XMLStreamException(name + " already defined", reader.getLocation());
                }
                case PATH: {
                    path = value;
                    continue block5;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        if (requirePath && path == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent(reader);
        ModelNode update = new ModelNode();
        update.get("address").set(address).add("path", name);
        update.get("operation").set("add");
        update.get("name").set(name);
        update.get("path").set(path);
        if (relativeTo != null) {
            update.get("relative-to").set(relativeTo);
        }
        list.add(update);
    }

    protected void parseSystemProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
                throw ParseUtils.unexpectedElement(reader);
            }
            if (Element.forName(reader.getLocalName()) != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement(reader);
            }
            String[] array = ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
            ParseUtils.requireNoContent(reader);
            ModelNode op = Util.getEmptyOperation("add-system-property", address);
            op.get("name").set(array[0]);
            op.get("value").set(array[1]);
            updates.add(op);
        }
    }

    protected ModelNode parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode properties = new ModelNode();
        while (reader.nextTag() != 2) {
            if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
                throw ParseUtils.unexpectedElement(reader);
            }
            if (Element.forName(reader.getLocalName()) != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement(reader);
            }
            String[] array = ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
            ParseUtils.requireNoContent(reader);
            properties.get(array[0]).set(array[1]);
        }
        return properties;
    }

    protected void parseHttpManagementSocket(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String interfaceName = null;
        int port = 0;
        int maxThreads = -1;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    interfaceName = value;
                    continue block5;
                }
                case PORT: {
                    port = Integer.parseInt(value);
                    if (port >= 0) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + port + " -- cannot be negative", reader.getLocation());
                }
                case MAX_THREADS: {
                    maxThreads = Integer.parseInt(value);
                    if (maxThreads >= 1) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + maxThreads + " -- must be greater than 0", reader.getLocation());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (interfaceName == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        ModelNode mgmtSocket = new ModelNode();
        mgmtSocket.get("interface").set(interfaceName);
        mgmtSocket.get("port").set(port);
        mgmtSocket.get("operation").set("add");
        mgmtSocket.get("address").setEmptyList().add("management-interfaces", "http-interface");
        list.add(mgmtSocket);
        reader.discardRemainder();
    }

    private void parseNativeManagementSocket(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String interfaceName = null;
        int port = 0;
        int maxThreads = -1;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    interfaceName = value;
                    continue block5;
                }
                case PORT: {
                    port = Integer.parseInt(value);
                    if (port >= 0) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + port + " -- cannot be negative", reader.getLocation());
                }
                case MAX_THREADS: {
                    maxThreads = Integer.parseInt(value);
                    if (maxThreads >= 1) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + maxThreads + " -- must be greater than 0", reader.getLocation());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (interfaceName == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        ModelNode mgmtSocket = new ModelNode();
        mgmtSocket.get("interface").set(interfaceName);
        mgmtSocket.get("port").set(port);
        mgmtSocket.get("operation").set("add");
        mgmtSocket.get("address").setEmptyList().add("management-interfaces", "native-interface");
        list.add(mgmtSocket);
        reader.discardRemainder();
    }

    protected void parseJvm(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> updates, Set<String> jvmNames) throws XMLStreamException {
        ArrayList<ModelNode> attrUpdates = new ArrayList<ModelNode>();
        String name = null;
        String type = null;
        String home = null;
        Boolean debugEnabled = null;
        String debugOptions = null;
        Boolean envClasspathIgnored = null;
        int count = reader.getAttributeCount();
        block24: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (name != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    if (!jvmNames.add(value)) {
                        throw new XMLStreamException("Duplicate JVM declaration " + value, reader.getLocation());
                    }
                    name = value;
                    continue block24;
                }
                case JAVA_HOME: {
                    if (home != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    home = value;
                    ModelNode update = Util.getWriteAttributeOperation(null, "java-home", home);
                    attrUpdates.add(update);
                    continue block24;
                }
                case TYPE: {
                    try {
                        Enum.valueOf(JvmType.class, value);
                        type = value;
                        continue block24;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue(reader, i);
                    }
                }
                case DEBUG_ENABLED: {
                    if (debugEnabled != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    debugEnabled = Boolean.valueOf(value);
                    ModelNode update = Util.getWriteAttributeOperation(null, "debug-enabled", debugEnabled);
                    attrUpdates.add(update);
                    continue block24;
                }
                case DEBUG_OPTIONS: {
                    if (debugOptions != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    debugOptions = value;
                    ModelNode update = Util.getWriteAttributeOperation(null, "debug-options", debugOptions);
                    attrUpdates.add(update);
                    continue block24;
                }
                case ENV_CLASSPATH_IGNORED: {
                    if (envClasspathIgnored != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    envClasspathIgnored = Boolean.valueOf(value);
                    ModelNode update = Util.getWriteAttributeOperation(null, "env-classpath-ignored", envClasspathIgnored);
                    attrUpdates.add(update);
                    continue block24;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add("jvm", name);
        ModelNode addUpdate = new ModelNode();
        addUpdate.get("address").set(address);
        addUpdate.get("operation").set("add");
        addUpdate.get("name").set(name);
        if (type != null) {
            addUpdate.get("type").set(type);
        }
        updates.add(addUpdate);
        for (ModelNode attrUpdate : attrUpdates) {
            attrUpdate.get("address").set(address);
            updates.add(attrUpdate);
        }
        boolean hasJvmOptions = false;
        boolean hasEnvironmentVariables = false;
        boolean hasSystemProperties = false;
        block26: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case HEAP: {
                            this.parseHeap(reader, address, updates);
                            continue block26;
                        }
                        case PERMGEN: {
                            this.parsePermgen(reader, address, updates);
                            continue block26;
                        }
                        case STACK: {
                            this.parseStack(reader, address, updates);
                            continue block26;
                        }
                        case AGENT_LIB: {
                            this.parseAgentLib(reader, address, updates);
                            continue block26;
                        }
                        case AGENT_PATH: {
                            this.parseAgentPath(reader, address, updates);
                            continue block26;
                        }
                        case JAVA_AGENT: {
                            this.parseJavaagent(reader, address, updates);
                            continue block26;
                        }
                        case ENVIRONMENT_VARIABLES: {
                            if (hasEnvironmentVariables) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            updates.add(Util.getWriteAttributeOperation(address, "environment-variables", this.parseProperties(reader)));
                            hasEnvironmentVariables = true;
                            continue block26;
                        }
                        case SYSTEM_PROPERTIES: {
                            if (hasSystemProperties) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            this.parseSystemProperties(reader, address, updates);
                            hasSystemProperties = true;
                            continue block26;
                        }
                        case JVM_OPTIONS: {
                            if (hasJvmOptions) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            this.parseJvmOptions(reader, address, updates);
                            hasJvmOptions = true;
                            continue block26;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseHeap(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String size = null;
        String maxSize = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    size = value;
                    continue block4;
                }
                case MAX_SIZE: {
                    maxSize = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (size != null || maxSize != null) {
            ModelNode update = Util.getWriteAttributeOperation(address, "heap", new ModelNode());
            if (size != null) {
                update.get(new String[]{"value", "size"}).set(size);
            }
            if (maxSize != null) {
                update.get(new String[]{"value", "max-size"}).set(maxSize);
            }
            updates.add(update);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parsePermgen(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String size = null;
        String maxSize = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    size = value;
                    continue block4;
                }
                case MAX_SIZE: {
                    maxSize = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (size != null || maxSize != null) {
            ModelNode update = Util.getWriteAttributeOperation(address, "heap", new ModelNode());
            if (size != null) {
                update.get(new String[]{"value", "size"}).set(size);
            }
            if (maxSize != null) {
                update.get(new String[]{"value", "max-size"}).set(maxSize);
            }
            updates.add(update);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStack(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean sizeSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    ModelNode update = Util.getWriteAttributeOperation(address, "stack-size", value);
                    updates.add(update);
                    sizeSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!sizeSet) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SIZE));
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseAgentLib(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    ModelNode update = Util.getWriteAttributeOperation(address, "agent-lib", value);
                    updates.add(update);
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseAgentPath(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    ModelNode update = Util.getWriteAttributeOperation(address, "agent-path", value);
                    updates.add(update);
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJavaagent(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    ModelNode update = Util.getWriteAttributeOperation(address, "java-agent", value);
                    updates.add(update);
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJvmOptions(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        boolean optionSet = false;
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == Element.OPTION) {
                        String option = null;
                        int count = reader.getAttributeCount();
                        block7: for (int i = 0; i < count; ++i) {
                            String attrValue = reader.getAttributeValue(i);
                            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case VALUE: {
                                    option = attrValue;
                                    continue block7;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute(reader, i);
                                }
                            }
                        }
                        if (option == null) {
                            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
                        }
                        ModelNode update = new ModelNode();
                        update.get("address").set(address);
                        update.get("operation").set("add-jvm-option");
                        update.get("option").set(option);
                        updates.add(update);
                        optionSet = true;
                        ParseUtils.requireNoContent(reader);
                        continue block6;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!optionSet) {
            throw ParseUtils.missingRequiredElement(reader, Collections.singleton(Element.OPTION));
        }
    }

    protected void parseInterfaceCriteria(XMLExtendedStreamReader reader, ModelNode criteria) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return;
        }
        if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
            throw ParseUtils.unexpectedElement(reader);
        }
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case ANY_ADDRESS: 
            case ANY_IPV4_ADDRESS: 
            case ANY_IPV6_ADDRESS: {
                criteria.set(element.getLocalName());
                ParseUtils.requireNoContent(reader);
                ParseUtils.requireNoContent(reader);
                return;
            }
        }
        do {
            element = Element.forName(reader.getLocalName());
            switch (element) {
                case ANY: {
                    this.parseCompoundInterfaceCriterion(reader, criteria.add().set("any", new ModelNode()).get("any"));
                    break;
                }
                case NOT: {
                    this.parseCompoundInterfaceCriterion(reader, criteria.add().set("not", new ModelNode()).get("not"));
                    break;
                }
                default: {
                    this.parseSimpleInterfaceCriterion(reader, criteria.add());
                }
            }
        } while (reader.nextTag() != 2);
    }

    protected void parseCompoundInterfaceCriterion(XMLExtendedStreamReader reader, ModelNode criterion) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        while (reader.nextTag() != 2) {
            this.parseSimpleInterfaceCriterion(reader, criterion.add());
        }
    }

    protected void parseSimpleInterfaceCriterion(XMLExtendedStreamReader reader, ModelNode criteria) throws XMLStreamException {
        if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
            throw ParseUtils.unexpectedElement(reader);
        }
        Element element = Element.forName(reader.getLocalName());
        String localName = element.getLocalName();
        switch (element) {
            case INET_ADDRESS: {
                ParseUtils.requireSingleAttribute(reader, Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName, value);
                break;
            }
            case LOOPBACK_ADDRESS: {
                ParseUtils.requireSingleAttribute(reader, Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName, value);
                break;
            }
            case LINK_LOCAL_ADDRESS: 
            case LOOPBACK: 
            case MULTICAST: 
            case POINT_TO_POINT: 
            case PUBLIC_ADDRESS: 
            case SITE_LOCAL_ADDRESS: 
            case UP: 
            case VIRTUAL: {
                ParseUtils.requireNoAttributes(reader);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName);
                break;
            }
            case NIC: {
                ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName, value);
                break;
            }
            case NIC_MATCH: {
                ParseUtils.requireSingleAttribute(reader, Attribute.PATTERN.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName, value);
                break;
            }
            case SUBNET_MATCH: {
                ParseUtils.requireSingleAttribute(reader, Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                String[] split = value.split("/");
                try {
                    if (split.length != 2) {
                        throw new XMLStreamException("Invalid 'value' " + value + " -- must be of the form address/mask", reader.getLocation());
                    }
                    InetAddress addr = InetAddress.getByName(split[0]);
                    addr.getAddress();
                    Integer.parseInt(split[1]);
                    criteria.set(localName, value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException("Invalid mask " + split[1] + " (" + e.getLocalizedMessage() + ")", reader.getLocation(), e);
                }
                catch (UnknownHostException e) {
                    throw new XMLStreamException("Invalid address " + split[1] + " (" + e.getLocalizedMessage() + ")", reader.getLocation(), e);
                }
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    protected void parseInterfaces(XMLExtendedStreamReader reader, Set<String> names, ModelNode address, List<ModelNode> list, boolean checkSpecified) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        while (reader.nextTag() != 2) {
            ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw new XMLStreamException("Duplicate interface declaration", reader.getLocation());
            }
            ModelNode interfaceAdd = new ModelNode();
            interfaceAdd.get("address").set(address).add("interface", name);
            interfaceAdd.get("operation").set("add");
            ModelNode criteriaNode = interfaceAdd.get("criteria");
            this.parseInterfaceCriteria(reader, criteriaNode);
            if (criteriaNode.getType() != ModelType.STRING && criteriaNode.asInt() == 0 && checkSpecified) {
                throw ParseUtils.unexpectedEndElement(reader);
            }
            list.add(interfaceAdd);
        }
    }

    protected void parseSocketBindingGroupRef(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = null;
        int offset = -1;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REF: {
                    if (name != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    name = value;
                    continue block6;
                }
                case PORT_OFFSET: {
                    try {
                        if (offset != -1) {
                            throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                        }
                        offset = Integer.parseInt(value);
                        if (offset >= 0) continue block6;
                        throw new XMLStreamException(offset + " is not a valid " + attribute.getLocalName() + " -- must be greater than zero", reader.getLocation());
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException(offset + " is not a valid " + attribute.getLocalName(), reader.getLocation(), e);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.REF));
        }
        ParseUtils.requireNoContent(reader);
        ModelNode update = Util.getWriteAttributeOperation(address, "socket-binding-group", name);
        updates.add(update);
        if (offset < 0) {
            offset = 0;
        }
        if (offset > 0) {
            update = Util.getWriteAttributeOperation(address, "socket-binding-port-offset", offset);
        }
        updates.add(update);
    }

    protected String parseSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, String inheritedInterfaceName, List<ModelNode> updates) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.PORT);
        String name = null;
        ModelNode binding = new ModelNode();
        binding.get("address");
        binding.get("operation").set("add");
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    binding.get("address").set(address).add("socket-binding", name);
                    continue block10;
                }
                case INTERFACE: {
                    if (!interfaces.contains(value)) {
                        throw new XMLStreamException("Unknown interface " + value + " " + attribute.getLocalName() + " must be declared in element " + Element.INTERFACES.getLocalName(), reader.getLocation());
                    }
                    binding.get("interface").set(value);
                    continue block10;
                }
                case PORT: {
                    binding.get("port").set(ParseUtils.parseBoundedIntegerAttribute(reader, i, 0, 65535));
                    continue block10;
                }
                case FIXED_PORT: {
                    binding.get("fixed-port").set(Boolean.parseBoolean(value));
                    continue block10;
                }
                case MULTICAST_ADDRESS: {
                    try {
                        InetAddress mcastAddr = InetAddress.getByName(value);
                        if (!mcastAddr.isMulticastAddress()) {
                            throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " is not a valid multicast address", reader.getLocation());
                        }
                        binding.get("multicast-address").set(value);
                        continue block10;
                    }
                    catch (UnknownHostException e) {
                        throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " is not a valid multicast address", reader.getLocation(), e);
                    }
                }
                case MULTICAST_PORT: {
                    binding.get("multicast-port").set(ParseUtils.parseBoundedIntegerAttribute(reader, i, 1, 65535));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
        ParseUtils.requireNoContent(reader);
        updates.add(binding);
        return name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeInterfaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        writer.writeStartElement(Element.INTERFACES.getLocalName());
        Set interfaces = modelNode.keys();
        for (String ifaceName : interfaces) {
            ModelNode iface = modelNode.get(ifaceName);
            writer.writeStartElement(Element.INTERFACE.getLocalName());
            CommonXml.writeAttribute(writer, Attribute.NAME, ifaceName);
            ModelNode criteria = iface.get("criteria");
            if (criteria.getType() == ModelType.STRING) {
                String value = criteria.asString();
                if (value.equals(Element.ANY_ADDRESS.getLocalName())) {
                    writer.writeEmptyElement(Element.ANY_ADDRESS.getLocalName());
                } else if (value.equals(Element.ANY_IPV4_ADDRESS.getLocalName())) {
                    writer.writeEmptyElement(Element.ANY_IPV4_ADDRESS.getLocalName());
                } else {
                    if (!value.equals(Element.ANY_IPV6_ADDRESS.getLocalName())) throw new RuntimeException("Unkown criteria type: " + value);
                    writer.writeEmptyElement(Element.ANY_IPV6_ADDRESS.getLocalName());
                }
            } else {
                if (criteria.getType() != ModelType.LIST) throw new RuntimeException("Unkown type for criteria node " + criteria);
                List values = criteria.asList();
                this.writeInterfaceCriteria(writer, values);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeInterfaceCriteria(XMLExtendedStreamWriter writer, List<ModelNode> criteria) throws XMLStreamException {
        for (ModelNode value : criteria) {
            if (value.getType() == ModelType.PROPERTY) {
                this.writePropertyInterfaceCriteria(writer, value);
                continue;
            }
            if (value.getType() == ModelType.LIST) {
                this.writeInterfaceCriteria(writer, value.asList());
                continue;
            }
            this.writeSimpleInterfaceCriteria(writer, value);
        }
    }

    private void writePropertyInterfaceCriteria(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        Property property = node.asProperty();
        Element element = Element.forName(property.getName());
        writer.writeStartElement(element.getLocalName());
        switch (element) {
            case ANY: {
                this.writeInterfaceCriteria(writer, property.getValue().asList());
                break;
            }
            case NOT: {
                this.writeInterfaceCriteria(writer, property.getValue().asList());
                break;
            }
            case INET_ADDRESS: {
                CommonXml.writeAttribute(writer, Attribute.VALUE, property.getValue().asString());
                break;
            }
            case NIC: {
                CommonXml.writeAttribute(writer, Attribute.NAME, property.getValue().asString());
                break;
            }
            case NIC_MATCH: {
                CommonXml.writeAttribute(writer, Attribute.PATTERN, property.getValue().asString());
                break;
            }
            case SUBNET_MATCH: {
                CommonXml.writeAttribute(writer, Attribute.VALUE, property.getValue().asString());
                break;
            }
            default: {
                throw new RuntimeException("Unknown property in interface criteria list: " + property);
            }
        }
        writer.writeEndElement();
    }

    private void writeSimpleInterfaceCriteria(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        Element element = Element.forName(node.asString());
        writer.writeEmptyElement(element.getLocalName());
    }

    protected void writeSocketBindingGroup(XMLExtendedStreamWriter writer, ModelNode bindingGroup, boolean fromServer) throws XMLStreamException {
        writer.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
        ModelNode attr = bindingGroup.get("name");
        CommonXml.writeAttribute(writer, Attribute.NAME, attr.asString());
        attr = bindingGroup.get("default-interface");
        CommonXml.writeAttribute(writer, Attribute.DEFAULT_INTERFACE, attr.asString());
        if (fromServer && bindingGroup.has("port-offset") && bindingGroup.get("port-offset").asInt() != 0) {
            attr = bindingGroup.get("port-offset");
            CommonXml.writeAttribute(writer, Attribute.PORT_OFFSET, attr.asString());
        }
        if (!fromServer && bindingGroup.hasDefined("include")) {
            for (ModelNode include : bindingGroup.get("include").asList()) {
                writer.writeStartElement(Element.INCLUDE.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.SOCKET_BINDING_GROUP, include.asString());
                writer.writeEndElement();
            }
        }
        if (bindingGroup.hasDefined("socket-binding")) {
            ModelNode bindings = bindingGroup.get("socket-binding");
            for (String bindingName : bindings.keys()) {
                ModelNode binding = bindings.get(bindingName);
                writer.writeStartElement(Element.SOCKET_BINDING.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, bindingName);
                attr = binding.get("port");
                CommonXml.writeAttribute(writer, Attribute.PORT, attr.asString());
                attr = binding.get("fixed-port");
                if (attr.isDefined() && attr.asBoolean()) {
                    CommonXml.writeAttribute(writer, Attribute.FIXED_PORT, attr.asString());
                }
                if ((attr = binding.get("interface")).isDefined()) {
                    CommonXml.writeAttribute(writer, Attribute.INTERFACE, attr.asString());
                }
                if ((attr = binding.get("multicast-address")).isDefined()) {
                    CommonXml.writeAttribute(writer, Attribute.MULTICAST_ADDRESS, attr.asString());
                }
                if ((attr = binding.get("multicast-port")).isDefined()) {
                    CommonXml.writeAttribute(writer, Attribute.MULTICAST_PORT, attr.asString());
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    protected void writeProperties(XMLExtendedStreamWriter writer, ModelNode modelNode, Element element) throws XMLStreamException {
        List properties = modelNode.asPropertyList();
        if (properties.size() > 0) {
            writer.writeStartElement(element.getLocalName());
            for (Property prop : properties) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, prop.getName());
                CommonXml.writeAttribute(writer, Attribute.VALUE, prop.getValue().asString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    protected static void writeAttribute(XMLExtendedStreamWriter writer, Attribute attribute, String value) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), value);
    }

    protected void writeJVMElement(XMLExtendedStreamWriter writer, String jvmName, ModelNode jvmElement) throws XMLStreamException {
        ModelNode permGen;
        ModelNode heap;
        writer.writeStartElement(Element.JVM.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), jvmName);
        if (jvmElement.hasDefined("type")) {
            writer.writeAttribute(Attribute.TYPE.getLocalName(), jvmElement.get("type").asString());
        }
        if (jvmElement.hasDefined("java-home")) {
            writer.writeAttribute(Attribute.JAVA_HOME.getLocalName(), jvmElement.get("java-home").asString());
        }
        if (jvmElement.hasDefined("debug-enabled")) {
            writer.writeAttribute(Attribute.DEBUG_ENABLED.getLocalName(), jvmElement.get("debug-enabled").asString());
        }
        if (jvmElement.hasDefined("debug-options")) {
            writer.writeAttribute(Attribute.DEBUG_OPTIONS.getLocalName(), jvmElement.get("debug-options").asString());
        }
        if (jvmElement.hasDefined("env-classpath-ignored")) {
            writer.writeAttribute(Attribute.ENV_CLASSPATH_IGNORED.getLocalName(), jvmElement.get("env-classpath-ignored").asString());
        }
        if (jvmElement.hasDefined("heap") && ((heap = jvmElement.get("heap")).hasDefined("size") || heap.hasDefined("max-size"))) {
            writer.writeEmptyElement(Element.HEAP.getLocalName());
            if (heap.hasDefined("size")) {
                writer.writeAttribute(Attribute.SIZE.getLocalName(), heap.get("size").asString());
            }
            if (heap.hasDefined("max-size")) {
                writer.writeAttribute(Attribute.MAX_SIZE.getLocalName(), heap.get("max-size").asString());
            }
        }
        if (jvmElement.hasDefined("permgen") && ((permGen = jvmElement.get("permgen")).hasDefined("size") || permGen.hasDefined("max-size"))) {
            writer.writeEmptyElement(Element.HEAP.getLocalName());
            if (permGen.hasDefined("size")) {
                writer.writeAttribute(Attribute.SIZE.getLocalName(), permGen.get("size").asString());
            }
            if (permGen.hasDefined("max-size")) {
                writer.writeAttribute(Attribute.MAX_SIZE.getLocalName(), permGen.get("max-size").asString());
            }
        }
        if (jvmElement.hasDefined("stack-size")) {
            writer.writeEmptyElement(Element.STACK.getLocalName());
            writer.writeAttribute(Attribute.SIZE.getLocalName(), jvmElement.get("stack-size").asString());
        }
        if (jvmElement.hasDefined("agent-lib")) {
            writer.writeEmptyElement(Element.AGENT_LIB.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), jvmElement.get("agent-lib").asString());
        }
        if (jvmElement.hasDefined("agent-path")) {
            writer.writeEmptyElement(Element.AGENT_PATH.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), jvmElement.get("agent-path").asString());
        }
        if (jvmElement.hasDefined("javaagent")) {
            writer.writeEmptyElement(Element.JAVA_AGENT.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), jvmElement.get("javaagent").asString());
        }
        if (jvmElement.hasDefined("jvm-options")) {
            writer.writeStartElement(Element.JVM_OPTIONS.getLocalName());
            for (ModelNode option : jvmElement.get("jvm-options").asList()) {
                writer.writeEmptyElement(Element.OPTION.getLocalName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), option.asString());
            }
            writer.writeEndElement();
        }
        if (jvmElement.hasDefined("environment-variables")) {
            writer.writeStartElement(Element.ENVIRONMENT_VARIABLES.getLocalName());
            for (Property variable : jvmElement.get("environment-variables").asPropertyList()) {
                writer.writeEmptyElement(Element.VARIABLE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), variable.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), variable.getValue().asString());
            }
            writer.writeEndElement();
        }
        if (jvmElement.hasDefined("system-properties")) {
            this.writeProperties(writer, jvmElement, Element.SYSTEM_PROPERTIES);
        }
        writer.writeEndElement();
    }

    protected void writeManagement(XMLExtendedStreamWriter writer, ModelNode serverManagement) throws XMLStreamException {
        writer.writeStartElement(Element.MANAGEMENT_INTERFACES.getLocalName());
        if (serverManagement.hasDefined("native-interface")) {
            this.writeManagementProtocol(Element.NATIVE_INTERFACE, writer, serverManagement.get("native-interface"));
        }
        if (serverManagement.hasDefined("http-interface")) {
            this.writeManagementProtocol(Element.HTTP_INTERFACE, writer, serverManagement.get("http-interface"));
        }
        writer.writeEndElement();
    }

    private void writeManagementProtocol(Element type, XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        String iface = protocol.get("interface").asString();
        String port = protocol.get("port").asString();
        writer.writeStartElement(type.getLocalName());
        CommonXml.writeAttribute(writer, Attribute.INTERFACE, iface);
        CommonXml.writeAttribute(writer, Attribute.PORT, port);
        if (protocol.hasDefined("max-threads")) {
            CommonXml.writeAttribute(writer, Attribute.MAX_THREADS, protocol.get("max-threads").asString());
        }
        writer.writeEndElement();
    }

    static {
        HashSet<String> set = new HashSet<String>(10);
        set.add("jboss.home");
        set.add("jboss.home.dir");
        set.add("user.home");
        set.add("user.dir");
        set.add("java.home");
        set.add("jboss.server.base.dir");
        set.add("jboss.server.data.dir");
        set.add("jboss.server.log.dir");
        set.add("jboss.server.temp.dir");
        set.add("jboss.modules.dir");
        set.add("jboss.server.deploy.dir");
        set.add("jboss.domain.servers.dir");
        RESTRICTED_PATHS = Collections.unmodifiableSet(set);
    }
}

