/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.PathDescription;
import org.jboss.as.controller.operations.common.PathRemoveHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PathAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final PathAddHandler NAMED_INSTANCE = new PathAddHandler(false);
    public static final PathAddHandler SPECIFIED_INSTANCE = new PathAddHandler(true);
    private final boolean specified;
    private final ParametersValidator validator = new ParametersValidator();

    public static ModelNode getAddPathOperation(ModelNode address, ModelNode path, ModelNode relativeTo) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        if (path.isDefined()) {
            op.get("path").set(path);
        }
        if (relativeTo.isDefined()) {
            op.get("relative-to").set(relativeTo);
        }
        return op;
    }

    protected PathAddHandler(boolean specified) {
        this.specified = specified;
        this.validator.registerValidator("path", new StringLengthValidator(1, !specified));
        this.validator.registerValidator("relative-to", new ModelTypeValidator(ModelType.STRING, true));
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        this.validator.validate(operation);
        ModelNode model = context.getSubModel();
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode compensating = PathRemoveHandler.getRemovePathOperation(operation.get("address"));
        ModelNode pathNode = operation.get("path");
        ModelNode relNode = operation.get("relative-to");
        model.get("name").set(name);
        model.get("path").set(pathNode);
        model.get("relative-to").set(relNode);
        String path = pathNode.isDefined() ? pathNode.asString() : null;
        String relativeTo = relNode.isDefined() ? relNode.asString() : null;
        return this.installPath(name, path, relativeTo, context, resultHandler, compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return this.specified ? PathDescription.getSpecifiedPathAddOperation(locale) : PathDescription.getNamedPathAddOperation(locale);
    }

    protected OperationResult installPath(String name, String path, String relativeTo, OperationContext context, ResultHandler resultHandler, ModelNode compensatingOp) {
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }
}

