/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.SnapshotDescriptions;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.dmr.ModelNode;

public class SnapshotListHandler
implements ModelQueryOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "list-snapshots";
    private final ConfigurationPersister persister;

    public SnapshotListHandler(ConfigurationPersister persister) {
        this.persister = persister;
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        try {
            ConfigurationPersister.SnapshotInfo info = this.persister.listSnapshots();
            ModelNode result = new ModelNode();
            result.get("directory").set(info.getSnapshotDirectory());
            result.get("names").setEmptyList();
            for (String name : info.names()) {
                result.get("names").add(name);
            }
            resultHandler.handleResultFragment(new String[0], result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage(), new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return SnapshotDescriptions.getSnapshotListModel(locale);
    }
}

