/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.CommonXml;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DomainXml
extends CommonXml {
    public DomainXml(ModuleLoader loader) {
        super(loader);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> nodes) throws XMLStreamException {
        this.readDomainElement(reader, new ModelNode(), nodes);
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        ModelNode modelNode = context.getModelNode();
        writer.writeStartDocument();
        writer.writeStartElement(Element.DOMAIN.getLocalName());
        writer.writeDefaultNamespace(Namespace.CURRENT.getUriString());
        this.writeNamespaces(writer, modelNode);
        this.writeSchemaLocation(writer, modelNode);
        if (modelNode.hasDefined("extension")) {
            this.writeExtensions(writer, modelNode.get("extension"));
        }
        if (modelNode.hasDefined("path")) {
            this.writePaths(writer, modelNode.get("path"));
        }
        if (modelNode.hasDefined("profile")) {
            writer.writeStartElement(Element.PROFILES.getLocalName());
            for (Property profile : modelNode.get("profile").asPropertyList()) {
                this.writeProfile(writer, profile.getName(), profile.getValue(), context);
            }
            writer.writeEndElement();
        }
        if (modelNode.hasDefined("interface")) {
            this.writeInterfaces(writer, modelNode.get("interface"));
        }
        if (modelNode.hasDefined("socket-binding-group")) {
            writer.writeStartElement(Element.SOCKET_BINDING_GROUPS.getLocalName());
            for (Property property : modelNode.get("socket-binding-group").asPropertyList()) {
                this.writeSocketBindingGroup(writer, property.getValue(), false);
            }
            writer.writeEndElement();
        }
        if (modelNode.hasDefined("system-properties")) {
            this.writeProperties(writer, modelNode.get("system-properties"), Element.SYSTEM_PROPERTIES, false);
        }
        if (modelNode.hasDefined("deployment")) {
            this.writeDomainDeployments(writer, modelNode.get("deployment"));
        }
        if (modelNode.hasDefined("server-group")) {
            writer.writeStartElement(Element.SERVER_GROUPS.getLocalName());
            for (Property property : modelNode.get("server-group").asPropertyList()) {
                this.writeServerGroup(writer, property.getName(), property.getValue());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    void readDomainElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri(reader.getAttributeNamespace(i))) {
                case DOMAIN_1_0: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName(reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block8;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block8;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        Element element = ParseUtils.nextElement(reader);
        if (element == Element.EXTENSIONS) {
            this.parseExtensions(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, list, true);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.PROFILES) {
            this.parseProfiles(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, list, false);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            this.parseDomainSocketBindingGroups(reader, address, list, interfaceNames);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, list, false);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.SERVER_GROUPS) {
            this.parseServerGroups(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    void parseDomainSocketBindingGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> interfaces) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SOCKET_BINDING_GROUP: {
                            this.parseSocketBindingGroup(reader, interfaces, address, list);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    void parseSocketBindingGroup(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> includedGroups = new HashSet<String>();
        HashSet<String> socketBindings = new HashSet<String>();
        String[] attrValues = ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.DEFAULT_INTERFACE.getLocalName());
        String name = attrValues[0];
        String defaultInterface = attrValues[1];
        ModelNode groupAddress = new ModelNode().set(address);
        groupAddress.add("socket-binding-group", name);
        ModelNode bindingGroupUpdate = new ModelNode();
        bindingGroupUpdate.get("address").set(groupAddress);
        bindingGroupUpdate.get("operation").set("add");
        bindingGroupUpdate.get("default-interface").set(defaultInterface);
        ModelNode includes = bindingGroupUpdate.get("include");
        includes.setEmptyList();
        updates.add(bindingGroupUpdate);
        block7: while (reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case INCLUDE: {
                            String includedGroup = ParseUtils.readStringAttributeElement(reader, Attribute.SOCKET_BINDING_GROUP.getLocalName());
                            if (!includedGroups.add(includedGroup)) {
                                throw new XMLStreamException("Included socket-binding-group " + includedGroup + " already declared", reader.getLocation());
                            }
                            includes.add(includedGroup);
                            continue block7;
                        }
                        case SOCKET_BINDING: {
                            String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, defaultInterface, updates);
                            if (socketBindings.add(bindingName)) continue block7;
                            throw new XMLStreamException("socket-binding " + bindingName + " already declared", reader.getLocation());
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    void parseServerGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            String name = null;
            String profile = null;
            int count = reader.getAttributeCount();
            block14: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (name != null) {
                            throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                        }
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement(reader, value);
                        }
                        name = value;
                        continue block14;
                    }
                    case PROFILE: {
                        if (profile != null) {
                            throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                        }
                        profile = value;
                        continue block14;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
            }
            if (profile == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PROFILE));
            }
            ModelNode groupAddress = new ModelNode().set(address);
            groupAddress.add("server-group", name);
            ModelNode group = new ModelNode();
            group.get("operation").set("add");
            group.get("address").set(groupAddress);
            group.get("profile").set(profile);
            list.add(group);
            boolean sawDeployments = false;
            block15: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DOMAIN_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case JVM: {
                                this.parseJvm(reader, groupAddress, list, new HashSet<String>());
                                continue block15;
                            }
                            case SOCKET_BINDING_GROUP: {
                                this.parseSocketBindingGroupRef(reader, groupAddress, list);
                                continue block15;
                            }
                            case DEPLOYMENTS: {
                                if (sawDeployments) {
                                    throw new XMLStreamException(element.getLocalName() + " already defined", reader.getLocation());
                                }
                                sawDeployments = true;
                                this.parseDeployments(reader, groupAddress, list);
                                continue block15;
                            }
                            case SYSTEM_PROPERTIES: {
                                this.parseSystemProperties(reader, groupAddress, list, false);
                                continue block15;
                            }
                        }
                        throw ParseUtils.unexpectedElement(reader);
                    }
                }
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    void parseDeployments(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            String uniqueName = null;
            String runtimeName = null;
            byte[] hash = null;
            String enabled = null;
            int count = reader.getAttributeCount();
            block9: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement(reader, value);
                        }
                        uniqueName = value;
                        continue block9;
                    }
                    case RUNTIME_NAME: {
                        runtimeName = value;
                        continue block9;
                    }
                    case SHA1: {
                        try {
                            hash = HashUtil.hexStringToByteArray(value);
                            continue block9;
                        }
                        catch (Exception e) {
                            throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " does not represent a properly hex-encoded SHA1 hash", reader.getLocation(), e);
                        }
                    }
                    case ENABLED: {
                        enabled = value;
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            if (uniqueName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
            }
            if (runtimeName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.RUNTIME_NAME));
            }
            if (hash == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SHA1));
            }
            boolean toStart = enabled == null ? true : Boolean.parseBoolean(enabled);
            ParseUtils.requireNoContent(reader);
            ModelNode deploymentAdd = new ModelNode();
            deploymentAdd.get("operation").set("add");
            deploymentAdd.get("address").set(address).add("deployment", uniqueName);
            deploymentAdd.get("runtime-name").set(runtimeName);
            deploymentAdd.get("hash").set(hash);
            deploymentAdd.get("enabled").set(toStart);
            list.add(deploymentAdd);
        }
    }

    void parseProfiles(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw new XMLStreamException("Duplicate profile declaration " + name, reader.getLocation());
            }
            ArrayList subsystems = new ArrayList();
            HashSet<String> includes = new HashSet<String>();
            ModelNode profileIncludes = new ModelNode();
            HashSet<String> configuredSubsystemTypes = new HashSet<String>();
            block5: while (reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case UNKNOWN: {
                        if (Element.forName(reader.getLocalName()) != Element.SUBSYSTEM) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        if (!configuredSubsystemTypes.add(reader.getNamespaceURI())) {
                            throw new XMLStreamException("Duplicate subsystem declaration", reader.getLocation());
                        }
                        reader.handleAny(subsystems);
                        continue block5;
                    }
                    case DOMAIN_1_0: {
                        if (configuredSubsystemTypes.size() > 0) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        if (Element.forName(reader.getLocalName()) != Element.INCLUDE) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        String includedName = ParseUtils.readStringAttributeElement(reader, Attribute.PROFILE.getLocalName());
                        if (!names.contains(includedName)) {
                            throw new XMLStreamException("No profile found for inclusion", reader.getLocation());
                        }
                        if (!includes.add(includedName)) {
                            throw new XMLStreamException("Duplicate profile include", reader.getLocation());
                        }
                        profileIncludes.add(includedName);
                        continue block5;
                    }
                }
                throw ParseUtils.unexpectedElement(reader);
            }
            ModelNode profile = new ModelNode();
            profile.get("operation").set("add");
            profile.get("address").set(address).add("profile", name);
            profile.get("includes").set(profileIncludes);
            list.add(profile);
            for (ModelNode update : subsystems) {
                ModelNode subsystemAddress = address.clone().set(address).add("profile", name);
                for (Property path : update.get("address").asPropertyList()) {
                    subsystemAddress.add(path.getName(), path.getValue().asString());
                }
                update.get("address").set(subsystemAddress);
                list.add(update);
            }
            if (configuredSubsystemTypes.size() != 0) continue;
            throw new XMLStreamException("Profile has no subsystem configurations", reader.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProfile(XMLExtendedStreamWriter writer, String profileName, ModelNode profileNode, ModelMarshallingContext context) throws XMLStreamException {
        writer.writeStartElement(Element.PROFILE.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), profileName);
        Set subsystemNames = profileNode.get("subsystem").keys();
        if (subsystemNames.size() > 0) {
            String defaultNamespace = writer.getNamespaceContext().getNamespaceURI("");
            for (String subsystemName : subsystemNames) {
                try {
                    ModelNode subsystem = profileNode.get(new String[]{"subsystem", subsystemName});
                    XMLElementWriter<SubsystemMarshallingContext> subsystemWriter = context.getSubsystemWriter(subsystemName);
                    if (subsystemWriter == null) continue;
                    subsystemWriter.writeContent(writer, (Object)new SubsystemMarshallingContext(subsystem, writer));
                }
                finally {
                    writer.setDefaultNamespace(defaultNamespace);
                }
            }
        }
        writer.writeEndElement();
    }

    private void writeDomainDeployments(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set deploymentNames = modelNode.keys();
        if (deploymentNames.size() > 0) {
            writer.writeStartElement(Element.DEPLOYMENTS.getLocalName());
            for (String uniqueName : deploymentNames) {
                ModelNode deployment = modelNode.get(uniqueName);
                String runtimeName = deployment.get("runtime-name").asString();
                String sha1 = HashUtil.bytesToHexString(deployment.get("hash").asBytes());
                writer.writeStartElement(Element.DEPLOYMENT.getLocalName());
                DomainXml.writeAttribute(writer, Attribute.NAME, uniqueName);
                DomainXml.writeAttribute(writer, Attribute.RUNTIME_NAME, runtimeName);
                DomainXml.writeAttribute(writer, Attribute.SHA1, sha1);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeServerGroup(XMLExtendedStreamWriter writer, String groupName, ModelNode group) throws XMLStreamException {
        String portOffset;
        Iterator i$;
        writer.writeStartElement(Element.SERVER_GROUP.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), groupName);
        writer.writeAttribute(Attribute.PROFILE.getLocalName(), group.get("profile").asString());
        if (group.hasDefined("jvm") && (i$ = group.get("jvm").asPropertyList().iterator()).hasNext()) {
            Property jvm = (Property)i$.next();
            this.writeJVMElement(writer, jvm.getName(), jvm.getValue());
        }
        String bindingGroupRef = group.hasDefined("socket-binding-group") ? group.get("socket-binding-group").asString() : null;
        String string = portOffset = group.hasDefined("socket-binding-port-offset") ? group.get("socket-binding-port-offset").asString() : null;
        if (bindingGroupRef != null || portOffset != null) {
            writer.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
            if (bindingGroupRef != null) {
                DomainXml.writeAttribute(writer, Attribute.REF, bindingGroupRef);
            }
            if (portOffset != null) {
                DomainXml.writeAttribute(writer, Attribute.PORT_OFFSET, portOffset);
            }
            writer.writeEndElement();
        }
        if (group.hasDefined("deployment")) {
            this.writeDomainDeployments(writer, group.get("deployment"));
        }
        if (group.hasDefined("system-properties")) {
            this.writeProperties(writer, group.get("system-properties"), Element.SYSTEM_PROPERTIES, false);
        }
        writer.writeEndElement();
    }
}

