/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.dmr.ModelNode;

public class ParametersOfValidator
implements ParameterValidator {
    private final ParametersValidator delegate;

    public ParametersOfValidator(ParametersValidator delegate) {
        assert (delegate != null) : "delegate is null";
        this.delegate = delegate;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        try {
            this.delegate.validate(value);
        }
        catch (OperationFailedException e) {
            ModelNode failureDescription = new ModelNode().add("Validation failed for " + parameterName);
            failureDescription.add(e.getFailureDescription());
            throw new OperationFailedException(e.getMessage(), e.getCause(), failureDescription);
        }
    }

    @Override
    public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
        try {
            this.delegate.validateResolved(value);
        }
        catch (OperationFailedException e) {
            throw new OperationFailedException(e.getMessage(), e.getCause(), new ModelNode().set(parameterName + ": " + e.getFailureDescription().asString()));
        }
    }
}

