/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandler;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.protocol.old.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;

public class ModelControllerClientOperationHandler
extends AbstractModelControllerOperationHandler {
    private final Map<Integer, Thread> asynchRequests = Collections.synchronizedMap(new HashMap());

    public ModelControllerClientOperationHandler(ExecutorService executorService, ModelController controller) {
        super(executorService, controller);
    }

    @Override
    public ManagementRequestHandler getRequestHandler(byte id) {
        if (id == 70) {
            return new ExecuteRequestHandler(false);
        }
        if (id == 69) {
            return new ExecuteRequestHandler(true);
        }
        if (id == 77) {
            return new CancelAsyncRequestHandler();
        }
        return null;
    }

    private class CancelAsyncRequestHandler
    extends ManagementRequestHandler {
        private int batchId;

        private CancelAsyncRequestHandler() {
        }

        protected void readRequest(DataInput input) throws IOException {
            this.batchId = this.getHeader().getBatchId();
        }

        protected void processRequest() throws RequestProcessingException {
            Thread t = (Thread)ModelControllerClientOperationHandler.this.asynchRequests.get(this.batchId);
            if (t == null) {
                throw new RequestProcessingException("No asynch request with batch id " + this.batchId);
            }
            t.interrupt();
        }
    }

    private class ExecuteRequestHandler
    extends ManagementRequestHandler {
        private final boolean asynch;
        private ModelNode operation = new ModelNode();
        private int batchId;
        private int attachmentsLength;
        private ModelNode result;

        public ExecuteRequestHandler(boolean asynch) {
            this.asynch = asynch;
        }

        protected void readRequest(DataInput input) throws IOException {
            this.batchId = this.getHeader().getBatchId();
            ProtocolUtils.expectHeader((DataInput)input, (int)97);
            this.operation.readExternal(input);
            ProtocolUtils.expectHeader((DataInput)input, (int)101);
            this.attachmentsLength = input.readInt();
        }

        protected void processRequest() throws RequestProcessingException {
            if (!this.asynch) {
                this.doProcessRequest();
            } else {
                Future<Void> future = ModelControllerClientOperationHandler.this.executorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ExecuteRequestHandler.this.doProcessRequest();
                        return null;
                    }
                });
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RequestProcessingException) {
                        throw (RequestProcessingException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RequestProcessingException(cause);
                }
                catch (InterruptedException e) {
                    Thread t = (Thread)ModelControllerClientOperationHandler.this.asynchRequests.get(this.batchId);
                    if (t != null) {
                        t.interrupt();
                    }
                    Thread.currentThread().interrupt();
                    throw new RequestProcessingException("Thread was interrupted waiting for a response for asynch operation");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doProcessRequest() {
            HandleableCloseable.Key closeKey = this.getChannel().addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    ModelControllerClientOperationHandler.this.asynchRequests.remove(ExecuteRequestHandler.this.getHeader().getBatchId());
                }
            });
            AbstractModelControllerOperationHandler.OperationAttachmentsProxy attachmentsProxy = new AbstractModelControllerOperationHandler.OperationAttachmentsProxy(this.getChannel(), this.batchId, this.attachmentsLength);
            try {
                try {
                    ModelControllerClientOperationHandler.this.log.tracef("Executing client request %d(%d)", (Object)this.batchId, (Object)this.getHeader().getRequestId());
                    if (this.asynch) {
                        ModelControllerClientOperationHandler.this.asynchRequests.put(this.batchId, Thread.currentThread());
                    }
                    this.result = ModelControllerClientOperationHandler.this.controller.execute(this.operation, new AbstractModelControllerOperationHandler.OperationMessageHandlerProxy(this.getChannel(), this.batchId), ModelController.OperationTransactionControl.COMMIT, attachmentsProxy);
                }
                catch (Exception e) {
                    ModelNode failure = new ModelNode();
                    failure.get("outcome").set("failed");
                    failure.get("failure-description").set(e.getClass().getName() + ":" + e.getMessage());
                    this.result = failure;
                    attachmentsProxy.shutdown(e);
                }
                finally {
                    ModelControllerClientOperationHandler.this.log.tracef("Executed client request %d", (Object)this.batchId);
                }
            }
            finally {
                if (this.asynch) {
                    ModelControllerClientOperationHandler.this.asynchRequests.remove(this.batchId);
                }
                closeKey.remove();
            }
        }

        protected void writeResponse(FlushableDataOutput output) throws IOException {
            output.write(100);
            this.result.writeExternal((DataOutput)output);
        }
    }
}

