/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.operations.common.ExtensionAddHandler;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;

class ModelControllerImpl
implements ModelController {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.controller");
    private static final ModelNode EMPTY;
    private final ServiceRegistry serviceRegistry;
    private final ServiceTarget serviceTarget;
    private final ManagementResourceRegistration rootRegistration;
    private final Lock writeLock = new ReentrantLock();
    private final ContainerStateMonitor stateMonitor;
    private final RootResource model = new RootResource();
    private final ConfigurationPersister persister;
    private final OperationContext.Type controllerType;
    private final AtomicBoolean bootingFlag = new AtomicBoolean(true);
    private final OperationStepHandler prepareStep;
    private final ControlledProcessState processState;
    static final ThreadLocal<Boolean> RB_ON_RT_FAILURE;

    @Deprecated
    ModelControllerImpl(ModelNode model, ServiceRegistry serviceRegistry, ServiceTarget serviceTarget, ManagementResourceRegistration rootRegistration, ContainerStateMonitor stateMonitor, ConfigurationPersister persister, OperationContext.Type controllerType, OperationStepHandler prepareStep, ControlledProcessState processState) {
        this(serviceRegistry, serviceTarget, rootRegistration, stateMonitor, persister, controllerType, prepareStep, processState);
    }

    ModelControllerImpl(ServiceRegistry serviceRegistry, ServiceTarget serviceTarget, ManagementResourceRegistration rootRegistration, ContainerStateMonitor stateMonitor, ConfigurationPersister persister, OperationContext.Type controllerType, OperationStepHandler prepareStep, ControlledProcessState processState) {
        this.serviceRegistry = serviceRegistry;
        this.serviceTarget = serviceTarget;
        this.rootRegistration = rootRegistration;
        this.stateMonitor = stateMonitor;
        this.persister = persister;
        this.controllerType = controllerType;
        this.prepareStep = prepareStep == null ? new DefaultPrepareStepHandler() : prepareStep;
        this.processState = processState;
        this.serviceTarget.addListener(ServiceListener.Inheritance.ALL, (ServiceListener)stateMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments) {
        ModelNode headers = operation.has("operation-headers") ? operation.get("operation-headers") : null;
        boolean rollbackOnFailure = headers == null || !headers.hasDefined("rollback-on-runtime-failure") || headers.get("rollback-on-runtime-failure").asBoolean();
        EnumSet<OperationContextImpl.ContextFlag> contextFlags = rollbackOnFailure ? EnumSet.of(OperationContextImpl.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(OperationContextImpl.ContextFlag.class);
        OperationContextImpl context = new OperationContextImpl(this, this.controllerType, contextFlags, handler, attachments, this.model, control, this.processState, this.bootingFlag.get());
        ModelNode response = new ModelNode();
        context.addStep(response, operation, this.prepareStep, OperationContext.Stage.MODEL);
        RB_ON_RT_FAILURE.set(rollbackOnFailure);
        try {
            context.completeStep();
        }
        finally {
            RB_ON_RT_FAILURE.set(null);
        }
        ControlledProcessState.State state = this.processState.getState();
        switch (state) {
            case RELOAD_REQUIRED: 
            case RESTART_REQUIRED: {
                response.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                break;
            }
        }
        return response;
    }

    void boot(List<ModelNode> bootList, OperationMessageHandler handler, ModelController.OperationTransactionControl control) {
        OperationContextImpl context = new OperationContextImpl(this, this.controllerType, EnumSet.noneOf(OperationContextImpl.ContextFlag.class), handler, null, this.model, control, this.processState, this.bootingFlag.get());
        ModelNode result = context.getResult();
        result.setEmptyList();
        for (ModelNode bootOp : bootList) {
            ModelNode response = result.add();
            context.addStep(response, bootOp, new BootStepHandler(bootOp, response), OperationContext.Stage.MODEL);
        }
        context.completeStep();
    }

    void finshBoot() {
        this.bootingFlag.set(false);
    }

    Resource getRootResource() {
        return this.model;
    }

    ManagementResourceRegistration getRootRegistration() {
        return this.rootRegistration;
    }

    @Override
    public ModelControllerClient createClient(final Executor executor) {
        return new ModelControllerClient(){

            public void close() throws IOException {
            }

            public ModelNode execute(ModelNode operation) throws IOException {
                return this.execute(operation, null);
            }

            public ModelNode execute(Operation operation) throws IOException {
                return this.execute(operation, null);
            }

            public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) {
                return ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT, null);
            }

            public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return ModelControllerImpl.this.execute(operation.getOperation(), messageHandler, ModelController.OperationTransactionControl.COMMIT, (OperationAttachments)operation);
            }

            public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation, messageHandler, null);
            }

            public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation.getOperation(), messageHandler, (OperationAttachments)operation);
            }

            private AsyncFuture<ModelNode> executeAsync(final ModelNode operation, final OperationMessageHandler messageHandler, final OperationAttachments attachments) {
                if (executor == null) {
                    throw new IllegalStateException("Cannot execute asynchronous operation without an executor");
                }
                final AtomicReference opThread = new AtomicReference();
                class OpTask
                extends AsyncFutureTask<ModelNode> {
                    OpTask() {
                        super(executor);
                    }

                    public void asyncCancel(boolean interruptionDesired) {
                        Thread thread = (Thread)opThread.get();
                        if (thread != null) {
                            thread.interrupt();
                        }
                    }

                    void handleResult(ModelNode result) {
                        this.setResult(result);
                    }
                }
                final OpTask opTask = new OpTask();
                executor.execute(new Runnable(){
                    {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        opThread.set(Thread.currentThread());
                        try {
                            opTask.handleResult(ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT, attachments));
                        }
                        finally {
                            opThread.set(null);
                        }
                    }
                });
                return opTask;
            }
        };
    }

    ConfigurationPersister.PersistenceResource writeModel(final Resource resource, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        ModelNode newModel = Resource.Tools.readModel(resource);
        final ConfigurationPersister.PersistenceResource delegate = this.persister.store(newModel, affectedAddresses);
        return new ConfigurationPersister.PersistenceResource(){

            @Override
            public void commit() {
                ModelControllerImpl.this.model.set(resource);
                delegate.commit();
            }

            @Override
            public void rollback() {
                delegate.rollback();
            }
        };
    }

    void acquireLock(boolean interruptibly) throws InterruptedException {
        if (interruptibly) {
            this.writeLock.lockInterruptibly();
        } else {
            this.writeLock.lock();
        }
    }

    void releaseLock() {
        this.writeLock.unlock();
    }

    void acquireContainerMonitor() {
        this.stateMonitor.acquire();
    }

    void releaseContainerMonitor() {
        this.stateMonitor.release();
    }

    void awaitContainerMonitor(boolean interruptibly, int count) throws InterruptedException {
        if (interruptibly) {
            this.stateMonitor.await(count);
        } else {
            this.stateMonitor.awaitUninterruptibly(count);
        }
    }

    ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    ControlledProcessState.State getState() {
        return this.processState.getState();
    }

    Object setReloadRequired() {
        return this.processState.setReloadRequired();
    }

    Object setRestartRequired() {
        return this.processState.setRestartRequired();
    }

    void revertReloadRequired(Object stamp) {
        this.processState.revertReloadRequired(stamp);
    }

    void revertRestartRequired(Object stamp) {
        this.processState.revertRestartRequired(stamp);
    }

    static {
        ModelNode empty = new ModelNode();
        empty.protect();
        EMPTY = empty;
        RB_ON_RT_FAILURE = new ThreadLocal();
    }

    private class RootResource
    implements Resource {
        private final AtomicReference<Resource> modelReference = new AtomicReference<Resource>(Resource.Factory.create());

        private RootResource() {
        }

        void set(Resource resource) {
            this.modelReference.set(resource);
        }

        @Override
        public Resource clone() {
            return this.getDelegate().clone();
        }

        @Override
        public Resource getChild(PathElement element) {
            return this.getDelegate().getChild(element);
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            return this.getDelegate().getChildren(childType);
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            return this.getDelegate().getChildrenNames(childType);
        }

        @Override
        public Set<String> getChildTypes() {
            return this.getDelegate().getChildTypes();
        }

        @Override
        public ModelNode getModel() {
            return this.getDelegate().getModel();
        }

        @Override
        public boolean hasChild(PathElement element) {
            return this.getDelegate().hasChild(element);
        }

        @Override
        public boolean hasChildren(String childType) {
            return this.getDelegate().hasChildren(childType);
        }

        @Override
        public boolean isModelDefined() {
            return this.getDelegate().isModelDefined();
        }

        @Override
        public boolean isProxy() {
            return this.getDelegate().isProxy();
        }

        @Override
        public boolean isRuntime() {
            return this.getDelegate().isRuntime();
        }

        @Override
        public Resource navigate(PathAddress address) {
            return this.getDelegate().navigate(address);
        }

        @Override
        public void registerChild(PathElement address, Resource resource) {
            this.getDelegate().registerChild(address, resource);
        }

        @Override
        public Resource removeChild(PathElement address) {
            return this.getDelegate().removeChild(address);
        }

        @Override
        public Resource requireChild(PathElement element) {
            return this.getDelegate().requireChild(element);
        }

        @Override
        public void writeModel(ModelNode newModel) {
            this.getDelegate().writeModel(newModel);
        }

        private Resource getDelegate() {
            return this.modelReference.get();
        }
    }

    private class DefaultPrepareStepHandler
    implements OperationStepHandler {
        private DefaultPrepareStepHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Executing " + operation.get("operation") + " " + operation.get("address")));
            }
            PathAddress address = PathAddress.pathAddress(operation.get("address"));
            String operationName = operation.require("operation").asString();
            OperationStepHandler stepHandler = ModelControllerImpl.this.rootRegistration.getOperationHandler(address, operationName);
            if (stepHandler != null) {
                context.addStep(stepHandler, OperationContext.Stage.MODEL);
            } else {
                context.getFailureDescription().set(String.format("No handler for operation %s at address %s", operationName, address));
            }
            context.completeStep();
        }
    }

    class BootStepHandler
    implements OperationStepHandler {
        private final ModelNode operation;
        private final ModelNode response;

        BootStepHandler(ModelNode operation, ModelNode response) {
            this.operation = operation;
            this.response = response;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(operation.require("address"));
            String operationName = operation.require("operation").asString();
            OperationStepHandler stepHandler = ModelControllerImpl.this.rootRegistration.getOperationHandler(address, operationName);
            if (stepHandler == null) {
                context.getFailureDescription().set(String.format("No handler for operation %s at address %s", operationName, address));
            } else {
                OperationContext.Stage stage = OperationContext.Stage.MODEL;
                if (stepHandler instanceof ExtensionAddHandler) {
                    stage = OperationContext.Stage.IMMEDIATE;
                }
                context.addStep(this.response, this.operation, stepHandler, stage);
            }
            context.completeStep();
        }
    }
}

