/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LongRangeValidator
extends ModelTypeValidator {
    protected final long min;
    protected final long max;

    public LongRangeValidator(long min) {
        this(min, Long.MAX_VALUE, false, false);
    }

    public LongRangeValidator(long min, boolean nullable) {
        this(min, Integer.MAX_VALUE, nullable, false);
    }

    public LongRangeValidator(long min, long max, boolean nullable, boolean allowExpressions) {
        super(ModelType.LONG, nullable, allowExpressions, false);
        this.min = min;
        this.max = max;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            long val = value.asLong();
            if (val < this.min) {
                throw new OperationFailedException(new ModelNode().set(val + " is an invalid value for parameter " + parameterName + ". A minimum value of " + this.min + " is required"));
            }
            if (val > this.max) {
                throw new OperationFailedException(new ModelNode().set(val + " is an invalid value for parameter " + parameterName + ". A maximum value of " + this.max + " is required"));
            }
        }
    }
}

