/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SchemaLocationAddHandler
extends AbstractModelUpdateHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add-schema-location";
    public static final SchemaLocationAddHandler INSTANCE = new SchemaLocationAddHandler();
    private final ParameterValidator stringValidator = new ModelTypeValidator(ModelType.STRING);

    public static ModelNode getAddSchemaLocationOperation(ModelNode address, String schemaUrl, String schemaLocation) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("uri").set(schemaLocation);
        op.get("schema-location").set(schemaLocation);
        return op;
    }

    private SchemaLocationAddHandler() {
    }

    @Override
    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode uri = operation.get("uri");
        ModelNode location = operation.get("schema-location");
        ModelNode locations = model.get("schema-locations");
        this.validate(uri, location, locations);
        locations.add(uri.asString(), location.asString());
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddSchemaLocationOperation(locale);
    }

    private void validate(ModelNode uri, ModelNode location, ModelNode locations) throws OperationFailedException {
        this.stringValidator.validateParameter("uri", uri);
        this.stringValidator.validateParameter("schema-location", location);
        if (locations.isDefined()) {
            String uriString = uri.asString();
            for (ModelNode node : locations.asList()) {
                if (!uriString.equals(node.asProperty().getName())) continue;
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.schemaAlreadyRegistered(uriString, node.asProperty().getValue().asString())));
            }
        }
    }
}

