/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public interface OperationContext {
    public void addStep(OperationStepHandler var1, Stage var2) throws IllegalArgumentException;

    public void addStep(ModelNode var1, OperationStepHandler var2, Stage var3) throws IllegalArgumentException;

    public void addStep(ModelNode var1, ModelNode var2, OperationStepHandler var3, Stage var4) throws IllegalArgumentException;

    public InputStream getAttachmentStream(int var1);

    public int getAttachmentStreamCount();

    public ModelNode getResult();

    public boolean hasResult();

    public ResultAction completeStep();

    public void completeStep(RollbackHandler var1);

    public ModelNode getFailureDescription();

    public boolean hasFailureDescription();

    public Type getType();

    public boolean isBooting();

    public boolean isRollbackOnly();

    public void setRollbackOnly();

    public boolean isRollbackOnRuntimeFailure();

    public boolean isResourceServiceRestartAllowed();

    public void reloadRequired();

    public void restartRequired();

    public void revertReloadRequired();

    public void revertRestartRequired();

    public void runtimeUpdateSkipped();

    public ImmutableManagementResourceRegistration getResourceRegistration();

    public ManagementResourceRegistration getResourceRegistrationForUpdate();

    public ServiceRegistry getServiceRegistry(boolean var1) throws UnsupportedOperationException;

    public ServiceController<?> removeService(ServiceName var1) throws UnsupportedOperationException;

    public void removeService(ServiceController<?> var1) throws UnsupportedOperationException;

    public ServiceTarget getServiceTarget() throws UnsupportedOperationException;

    @Deprecated
    public ModelNode readModel(PathAddress var1);

    @Deprecated
    public ModelNode readModelForUpdate(PathAddress var1);

    public void acquireControllerLock();

    public Resource createResource(PathAddress var1) throws UnsupportedOperationException;

    public void addResource(PathAddress var1, Resource var2);

    public Resource readResource(PathAddress var1);

    public Resource readResourceForUpdate(PathAddress var1);

    public Resource removeResource(PathAddress var1) throws UnsupportedOperationException;

    public Resource getRootResource();

    public Resource getOriginalRootResource();

    public boolean isModelAffected();

    public boolean isResourceRegistryAffected();

    public boolean isRuntimeAffected();

    public Stage getCurrentStage();

    public void report(MessageSeverity var1, String var2);

    public boolean markResourceRestarted(PathAddress var1, Object var2);

    public boolean revertResourceRestarted(PathAddress var1, Object var2);

    public ModelNode resolveExpressions(ModelNode var1) throws OperationFailedException;

    public static interface RollbackHandler {
        public static final RollbackHandler NOOP_ROLLBACK_HANDLER = new RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
            }
        };

        public void handleRollback(OperationContext var1, ModelNode var2);
    }

    public static enum ResultAction {
        KEEP,
        ROLLBACK;

    }

    public static enum Type {
        HOST,
        SERVER,
        MANAGEMENT;

    }

    public static enum Stage {
        IMMEDIATE,
        MODEL,
        RUNTIME,
        VERIFY,
        DOMAIN,
        DONE;


        boolean hasNext() {
            return this != DONE;
        }

        Stage next() {
            switch (this) {
                case MODEL: {
                    return RUNTIME;
                }
                case RUNTIME: {
                    return VERIFY;
                }
                case VERIFY: {
                    return DOMAIN;
                }
                case DOMAIN: {
                    return DONE;
                }
            }
            throw new IllegalStateException();
        }
    }
}

