/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionResource;
import org.jboss.as.controller.extension.SecurityActions;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class ExtensionAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final ExtensionRegistry extensionRegistry;
    private final boolean parallelBoot;

    public static ModelNode getAddExtensionOperation(ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        return op;
    }

    public ExtensionAddHandler(ExtensionRegistry extensionRegistry, boolean parallelBoot) {
        assert (extensionRegistry != null) : "extensionRegistry is null";
        this.extensionRegistry = extensionRegistry;
        this.parallelBoot = parallelBoot;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String moduleName = PathAddress.pathAddress(operation.require("address")).getLastElement().getValue();
        ExtensionResource resource = new ExtensionResource(moduleName, this.extensionRegistry);
        context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        if (!this.parallelBoot || !context.isBooting()) {
            this.initializeExtension(moduleName);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeExtension(String module) throws OperationFailedException {
        try {
            for (Extension extension : Module.loadServiceFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)module), Extension.class)) {
                ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(extension.getClass());
                try {
                    if (!this.extensionRegistry.getExtensionModuleNames().contains(module)) {
                        extension.initializeParsers(this.extensionRegistry.getExtensionParsingContext(module, null));
                    }
                    extension.initialize(this.extensionRegistry.getExtensionContext(module));
                }
                finally {
                    SecurityActions.setThreadContextClassLoader(oldTccl);
                }
            }
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }
}

