/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SnapshotTakeHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "take-snapshot";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("take-snapshot", ControllerResolver.getResolver("snapshot")).setReplyType(ModelType.STRING).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).build();
    private final ConfigurationPersister persister;

    public SnapshotTakeHandler(ConfigurationPersister persister) {
        this.persister = persister;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            String name = this.persister.snapshot();
            context.getResult().set(name);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
        catch (ConfigurationPersistenceException e) {
            throw new OperationFailedException(e.getMessage(), new ModelNode().set(e.getMessage()));
        }
    }
}

