/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.repository.impl;

import java.io.Closeable;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.server.deployment.repository.api.ServerDeploymentRepository;
import org.jboss.as.server.deployment.repository.impl.ContentRepositoryImpl;
import org.jboss.as.server.deployment.repository.impl.DeploymentRepositoryLogger;
import org.jboss.as.server.deployment.repository.impl.DeploymentRepositoryMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class ServerDeploymentRepositoryImpl
implements ServerDeploymentRepository,
Service<ServerDeploymentRepository> {
    private volatile TempFileProvider tempFileProvider;
    private final ContentRepositoryImpl contentRepository;

    public static void addService(ServiceTarget serviceTarget, ContentRepositoryImpl contentRepository) {
        serviceTarget.addService(ServerDeploymentRepository.SERVICE_NAME, (Service)new ServerDeploymentRepositoryImpl(contentRepository)).install();
    }

    public ServerDeploymentRepositoryImpl(ContentRepositoryImpl contentRepository) {
        this.contentRepository = contentRepository;
    }

    @Override
    public Closeable mountDeploymentContent(VirtualFile contents, VirtualFile mountPoint, boolean mountExpanded) throws IOException {
        if (contents == null) {
            throw DeploymentRepositoryMessages.MESSAGES.nullVar("contents");
        }
        if (mountExpanded) {
            return VFS.mountZipExpanded((VirtualFile)contents, (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
        }
        return VFS.mountZip((VirtualFile)contents, (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
    }

    public void start(StartContext context) throws StartException {
        try {
            JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("ServerDeploymentRepository-temp-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
            this.tempFileProvider = TempFileProvider.create((String)"temp", (ScheduledExecutorService)Executors.newScheduledThreadPool(2, (ThreadFactory)threadFactory));
        }
        catch (IOException e) {
            throw DeploymentRepositoryMessages.MESSAGES.failedCreatingTempProvider();
        }
        DeploymentRepositoryLogger.ROOT_LOGGER.debugf("%s started", ServerDeploymentRepository.class.getSimpleName());
    }

    public void stop(StopContext context) {
        DeploymentRepositoryLogger.ROOT_LOGGER.debugf("%s stopped", ServerDeploymentRepository.class.getSimpleName());
    }

    public ServerDeploymentRepository getValue() throws IllegalStateException {
        return this;
    }
}

