/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class DeploymentScannerDisable
implements ModelUpdateOperationHandler {
    static final DeploymentScannerDisable INSTANCE = new DeploymentScannerDisable();

    private DeploymentScannerDisable() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("enable");
        compensatingOperation.get("address").set(operation.require("address"));
        context.getSubModel().get("scan-enabled").set(false);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry().getService(DeploymentScannerService.getServiceName(name));
                    if (controller == null) {
                        throw new OperationFailedException(new ModelNode().set("scanner not configured"));
                    }
                    try {
                        DeploymentScanner scanner = (DeploymentScanner)controller.getValue();
                        scanner.stopScanner();
                        resultHandler.handleResultComplete();
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(DeploymentScannerDisable.this.getFailureResult(t));
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    protected ModelNode getFailureResult(Throwable t) {
        ModelNode node = new ModelNode();
        node.get("success").set(false);
        do {
            String message = t.getLocalizedMessage();
            node.get("cause").add(t.getClass().getName(), message != null ? message : "");
        } while ((t = t.getCause()) != null);
        return node;
    }
}

