/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.server.deployment.scanner.Attribute;
import org.jboss.as.server.deployment.scanner.DeploymentScannerAdd;
import org.jboss.as.server.deployment.scanner.DeploymentScannerDisable;
import org.jboss.as.server.deployment.scanner.DeploymentScannerEnable;
import org.jboss.as.server.deployment.scanner.DeploymentScannerRemove;
import org.jboss.as.server.deployment.scanner.DeploymentSubsystemProviders;
import org.jboss.as.server.deployment.scanner.Element;
import org.jboss.as.server.deployment.scanner.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DeploymentScannerExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment.scanner");
    public static final String SUBSYSTEM_NAME = "deployment-scanner";
    private static final PathElement scannersPath = PathElement.pathElement((String)"scanner");
    private static final DeploymentScannerParser parser = new DeploymentScannerParser();
    private static final String DEFAULT_SCANNER_NAME = "default";

    public void initialize(ExtensionContext context) {
        log.debug((Object)"Initializing Deployment Scanner Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(DeploymentSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)SubsystemAdd.INSTANCE, DeploymentSubsystemProviders.SUBSYSTEM_ADD, false);
        ModelNodeRegistration scanners = registration.registerSubModel(scannersPath, DeploymentSubsystemProviders.SCANNER);
        scanners.registerOperationHandler("add", (OperationHandler)DeploymentScannerAdd.INSTANCE, DeploymentSubsystemProviders.SCANNER_ADD, false);
        scanners.registerOperationHandler("remove", (OperationHandler)DeploymentScannerRemove.INSTANCE, DeploymentSubsystemProviders.SCANNER_REMOVE, false);
        scanners.registerOperationHandler("enable", (OperationHandler)DeploymentScannerEnable.INSTANCE, DeploymentSubsystemProviders.SCANNER_ENABLE, false);
        scanners.registerOperationHandler("disable", (OperationHandler)DeploymentScannerDisable.INSTANCE, DeploymentSubsystemProviders.SCANNER_DISABLE, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)parser);
    }

    static class DeploymentScannerParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        DeploymentScannerParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode scanners = context.getModelNode();
            for (Property list : scanners.asPropertyList()) {
                ModelNode node = list.getValue();
                for (Property scanner : node.asPropertyList()) {
                    writer.writeEmptyElement(Element.DEPLOYMENT_SCANNER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), scanner.getName());
                    ModelNode configuration = scanner.getValue();
                    if (this.has(configuration, "path")) {
                        writer.writeAttribute(Attribute.PATH.getLocalName(), configuration.get("path").asString());
                    }
                    if (this.has(configuration, "scan-enabled")) {
                        writer.writeAttribute(Attribute.SCAN_ENABLED.getLocalName(), configuration.get("scan-enabled").asString());
                    }
                    if (this.has(configuration, "scan-interval")) {
                        writer.writeAttribute(Attribute.SCAN_INTERVAL.getLocalName(), configuration.get("scan-interval").asString());
                    }
                    if (!configuration.has("relative-to")) continue;
                    writer.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), configuration.get("relative-to").asString());
                }
                writer.writeEndElement();
            }
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode address = new ModelNode();
            address.add("subsystem", DeploymentScannerExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DEPLOYMENT_SCANNER_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case DEPLOYMENT_SCANNER: {
                                this.parseScanner(reader, address, list);
                                continue block6;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseScanner(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            boolean enabled = true;
            int interval = 0;
            String path = null;
            String name = DeploymentScannerExtension.DEFAULT_SCANNER_NAME;
            String relativeTo = null;
            int attrCount = reader.getAttributeCount();
            block7: for (int i = 0; i < attrCount; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case PATH: {
                        path = value;
                        continue block7;
                    }
                    case NAME: {
                        name = value;
                        continue block7;
                    }
                    case RELATIVE_TO: {
                        relativeTo = value;
                        continue block7;
                    }
                    case SCAN_INTERVAL: {
                        interval = Integer.parseInt(value);
                        continue block7;
                    }
                    case SCAN_ENABLED: {
                        enabled = Boolean.parseBoolean(value);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
            }
            if (path == null) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("path"));
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            operation.get("address").set(address).add("scanner", name);
            operation.get("path").set(path);
            operation.get("scan-interval").set(interval);
            operation.get("scan-enabled").set(enabled);
            if (relativeTo != null) {
                operation.get("relative-to").set(relativeTo);
            }
            list.add(operation);
        }
    }

    static class SubsystemAdd
    implements ModelAddOperationHandler {
        static final SubsystemAdd INSTANCE = new SubsystemAdd();

        SubsystemAdd() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode compensatingOperation = new ModelNode();
            compensatingOperation.set("operation").set("remove");
            compensatingOperation.set("address").set(operation.get("address"));
            context.getSubModel().get("scanner");
            resultHandler.handleResultComplete();
            return new BasicOperationResult(compensatingOperation);
        }
    }
}

