/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.as.server.deployment.repository.api.ServerDeploymentRepository;
import org.jboss.as.server.deployment.scanner.ExtensibleFilter;
import org.jboss.as.server.deployment.scanner.ZipCompletionScanner;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

class FileSystemDeploymentService
implements DeploymentScanner {
    private static final Pattern ARCHIVE_PATTERN = Pattern.compile("^.*\\.[SsWwJjEeRr][Aa][Rr]$");
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment");
    static final String DEPLOYED = ".deployed";
    static final String FAILED_DEPLOY = ".failed";
    static final String DO_DEPLOY = ".dodeploy";
    static final String DEPLOYING = ".isdeploying";
    static final String UNDEPLOYING = ".isundeploying";
    static final String UNDEPLOYED = ".undeployed";
    static final String SKIP_DEPLOY = ".skipdeploy";
    static final String PENDING = ".pending";
    static final long MAX_NO_PROGRESS = 60000L;
    static final long DEFAULT_DEPLOYMENT_TIMEOUT = 60L;
    private File deploymentDir;
    private long scanInterval = 0L;
    private volatile boolean scanEnabled = false;
    private ScheduledFuture<?> scanTask;
    private ScheduledFuture<?> rescanIncompleteTask;
    private final Lock scanLock = new ReentrantLock();
    private final Map<String, DeploymentMarker> deployed = new HashMap<String, DeploymentMarker>();
    private final HashSet<String> ignoredMissingDeployments = new HashSet();
    private final HashSet<String> noticeLogged = new HashSet();
    private final HashSet<File> nonscannableLogged = new HashSet();
    private final Map<File, IncompleteDeploymentStatus> incompleteDeployments = new HashMap<File, IncompleteDeploymentStatus>();
    private final ScheduledExecutorService scheduledExecutor;
    private final ModelControllerClient controllerClient;
    private final ServerDeploymentRepository deploymentRepository;
    private final ContentRepository contentRepository;
    private FileFilter filter = new ExtensibleFilter();
    private volatile boolean autoDeployZip;
    private volatile boolean autoDeployExploded;
    private volatile long maxNoProgress = 60000L;
    private volatile long deploymentTimeout = 60L;
    private final String relativeTo;
    private final String relativePath;
    private final Runnable scanRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                FileSystemDeploymentService.this.scan();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Scan of %s threw Exception", (Object)FileSystemDeploymentService.this.deploymentDir.getAbsolutePath());
            }
        }
    };

    FileSystemDeploymentService(String relativeTo, File deploymentDir, File relativeToDir, ModelControllerClient controllerClient, ScheduledExecutorService scheduledExecutor, ServerDeploymentRepository deploymentRepository, ContentRepository contentRepository) throws OperationFailedException {
        assert (contentRepository != null) : "content repository is null";
        if (scheduledExecutor == null) {
            throw new IllegalStateException("null scheduled executor");
        }
        if (controllerClient == null) {
            throw new IllegalStateException("null controller client");
        }
        if (deploymentRepository == null) {
            throw new IllegalStateException("null deployment repository");
        }
        if (deploymentDir == null) {
            throw new IllegalStateException("null deployment dir");
        }
        if (!deploymentDir.exists()) {
            throw new IllegalArgumentException(deploymentDir.getAbsolutePath() + " does not exist");
        }
        if (!deploymentDir.isDirectory()) {
            throw new IllegalArgumentException(deploymentDir.getAbsolutePath() + " is not a directory");
        }
        if (!deploymentDir.canWrite()) {
            throw new IllegalArgumentException(deploymentDir.getAbsolutePath() + " is not writable");
        }
        this.relativeTo = relativeTo;
        this.deploymentDir = deploymentDir;
        this.controllerClient = controllerClient;
        this.scheduledExecutor = scheduledExecutor;
        this.deploymentRepository = deploymentRepository;
        this.contentRepository = contentRepository;
        if (relativeToDir != null) {
            String relDir;
            String fullDir = deploymentDir.getAbsolutePath();
            String sub = fullDir.substring((relDir = relativeToDir.getAbsolutePath()).length());
            if (sub.startsWith(File.separator)) {
                sub = sub.length() == 1 ? "" : sub.substring(1);
            }
            this.relativePath = sub.length() > 0 ? sub + "/" : sub;
        } else {
            this.relativePath = null;
        }
        this.establishDeployedContentList(deploymentDir);
    }

    @Override
    public boolean isAutoDeployZippedContent() {
        return this.autoDeployZip;
    }

    @Override
    public void setAutoDeployZippedContent(boolean autoDeployZip) {
        this.autoDeployZip = autoDeployZip;
    }

    @Override
    public boolean isAutoDeployExplodedContent() {
        return this.autoDeployExploded;
    }

    @Override
    public void setAutoDeployExplodedContent(boolean autoDeployExploded) {
        if (autoDeployExploded && !this.autoDeployExploded) {
            log.warnf("Reliable deployment behaviour is not possible when auto-deployment of exploded content is enabled (i.e. deployment without use of \"%s\"' marker files). Configuration of auto-deployment of exploded content is not recommended in any situation where reliability is desired. Configuring the deployment scanner's %s setting to \"false\" is recommended.", (Object)DO_DEPLOY, (Object)"auto-deploy-exploded");
        }
        this.autoDeployExploded = autoDeployExploded;
    }

    @Override
    public boolean isEnabled() {
        return this.scanEnabled;
    }

    @Override
    public long getScanInterval() {
        return this.scanInterval;
    }

    @Override
    public synchronized void setScanInterval(long scanInterval) {
        if (scanInterval != this.scanInterval) {
            this.cancelScan();
        }
        this.scanInterval = scanInterval;
        this.startScan();
    }

    @Override
    public void setDeploymentTimeout(long deploymentTimeout) {
        this.deploymentTimeout = deploymentTimeout;
    }

    @Override
    public synchronized void startScanner() {
        boolean scanEnabled = this.scanEnabled;
        if (scanEnabled) {
            return;
        }
        this.scanEnabled = true;
        this.startScan();
        log.infof("Started %s for directory %s", (Object)this.getClass().getSimpleName(), (Object)this.deploymentDir.getAbsolutePath());
    }

    @Override
    public synchronized void stopScanner() {
        this.scanEnabled = false;
        this.cancelScan();
    }

    void setMaxNoProgress(long max) {
        this.maxNoProgress = max;
    }

    private void establishDeployedContentList(File dir) throws OperationFailedException {
        File[] children;
        Set<String> deploymentNames = this.getDeploymentNames();
        for (File child : children = dir.listFiles()) {
            File skipDeploy;
            String fileName = child.getName();
            if (child.isDirectory()) {
                if (this.isEEArchive(fileName)) continue;
                this.establishDeployedContentList(child);
                continue;
            }
            if (!fileName.endsWith(DEPLOYED)) continue;
            String deploymentName = fileName.substring(0, fileName.length() - DEPLOYED.length());
            if (deploymentNames.contains(deploymentName)) {
                this.deployed.put(deploymentName, new DeploymentMarker(child.lastModified()));
                continue;
            }
            if (!child.delete()) {
                log.warnf("Cannot removed extraneous deployment marker file %s", (Object)fileName);
            }
            if ((skipDeploy = new File(dir, deploymentName + SKIP_DEPLOY)).exists()) continue;
            File deployedMarker = new File(dir, deploymentName + DO_DEPLOY);
            this.createMarkerFile(deployedMarker, deploymentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scan() {
        block34: {
            try {
                this.scanLock.lockInterruptibly();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            boolean scheduleRescan = false;
            try {
                if (!this.scanEnabled) break block34;
                log.tracef("Scanning directory %s for deployment content changes", (Object)this.deploymentDir.getAbsolutePath());
                ScanContext scanContext = new ScanContext();
                this.scanDirectory(this.deploymentDir, scanContext);
                this.ignoredMissingDeployments.retainAll(scanContext.ignoredMissingDeployments);
                for (String deploymentName : scanContext.ignoredMissingDeployments) {
                    if (!this.ignoredMissingDeployments.add(deploymentName)) continue;
                    log.warnf("Deployment of '%s' requested, but the deployment is not present", (Object)deploymentName);
                }
                this.noticeLogged.retainAll(scanContext.nonDeployable);
                for (Object fileName : scanContext.nonDeployable) {
                    if (!this.noticeLogged.add((String)fileName)) continue;
                    log.infof("Found %s in deployment directory. To trigger deployment create a file called %s%s", fileName, fileName, (Object)DO_DEPLOY);
                }
                ScanStatus status = this.handleAutoDeployFailures(scanContext);
                if (status != ScanStatus.PROCEED) {
                    if (status == ScanStatus.RETRY && this.scanInterval > 1000L) {
                        scheduleRescan = true;
                    }
                    return;
                }
                ArrayList<UndeployTask> scannerTasks = scanContext.scannerTasks;
                for (String missing : scanContext.toRemove) {
                    File file = this.deploymentDir;
                    scannerTasks.add(new UndeployTask(missing, file));
                }
                if (scannerTasks.size() > 0) {
                    ArrayList<Object> updates = new ArrayList<ModelNode>(scannerTasks.size());
                    for (ScannerTask scannerTask : scannerTasks) {
                        scannerTask.recordInProgress();
                        ModelNode update = scannerTask.getUpdate();
                        if (log.isDebugEnabled()) {
                            log.debugf("Deployment scan of [%s] found update action [%s]", (Object)this.deploymentDir, (Object)update);
                        }
                        updates.add(update);
                    }
                    while (!updates.isEmpty()) {
                        ModelNode failure;
                        ModelNode results;
                        ModelNode composite = this.getCompositeUpdate(updates);
                        DeploymentTask deploymentTask = new DeploymentTask(new OperationBuilder(composite).build());
                        Future<ModelNode> futureResults = this.scheduledExecutor.submit(deploymentTask);
                        try {
                            results = futureResults.get(this.deploymentTimeout, TimeUnit.SECONDS);
                        }
                        catch (TimeoutException e) {
                            futureResults.cancel(true);
                            failure = new ModelNode();
                            failure.get("outcome").set("failed");
                            failure.get("failure-description").set("Did not receive a response to the deployment operation within the allowed timeout period [" + this.deploymentTimeout + " seconds]. Check the server configuration" + "file and the server logs to find more about the status of the deployment.");
                            for (ScannerTask scannerTask : scannerTasks) {
                                scannerTask.handleFailureResult(failure);
                            }
                            break;
                        }
                        catch (Exception e) {
                            log.error((Object)"File system deployment service failed", (Throwable)e);
                            futureResults.cancel(true);
                            failure = new ModelNode();
                            failure.get("outcome").set("failed");
                            failure.get("failure-description").set(e.getMessage());
                            for (ScannerTask scannerTask : scannerTasks) {
                                scannerTask.handleFailureResult(failure);
                            }
                            break;
                        }
                        List resultList = results.get("result").asPropertyList();
                        ArrayList toRetry = new ArrayList();
                        ArrayList<UndeployTask> retryTasks = new ArrayList<UndeployTask>();
                        for (int i = 0; i < resultList.size(); ++i) {
                            ModelNode result = ((Property)resultList.get(i)).getValue();
                            ScannerTask task = (ScannerTask)scannerTasks.get(i);
                            ModelNode outcome = result.get("outcome");
                            if (outcome.isDefined() && "success".equals(outcome.asString())) {
                                task.handleSuccessResult();
                                continue;
                            }
                            if (outcome.isDefined() && "cancelled".equals(outcome.asString())) {
                                toRetry.add(updates.get(i));
                                retryTasks.add((UndeployTask)task);
                                continue;
                            }
                            task.handleFailureResult(result);
                        }
                        updates = toRetry;
                        scannerTasks = retryTasks;
                    }
                }
                log.tracef("Scan complete", new Object[0]);
            }
            finally {
                this.scanLock.unlock();
                if (scheduleRescan) {
                    Object fileName;
                    fileName = this;
                    synchronized (fileName) {
                        if (this.scanEnabled) {
                            this.rescanIncompleteTask = this.scheduledExecutor.schedule(this.scanRunnable, 200L, TimeUnit.MILLISECONDS);
                        }
                    }
                }
            }
        }
    }

    private void scanDirectory(File directory, ScanContext scanContext) {
        File[] children = directory.listFiles(this.filter);
        if (children == null) {
            return;
        }
        for (File child : children) {
            String fileName = child.getName();
            if (fileName.endsWith(DEPLOYED)) {
                String deploymentName = fileName.substring(0, fileName.length() - DEPLOYED.length());
                scanContext.toRemove.remove(deploymentName);
                if (!this.deployed.containsKey(deploymentName)) {
                    this.removeExtraneousMarker(child, fileName);
                    continue;
                }
                if (this.deployed.get(deploymentName).lastModified == child.lastModified()) continue;
                scanContext.scannerTasks.add(new RedeployTask(deploymentName, child.lastModified(), directory));
                continue;
            }
            if (fileName.endsWith(DO_DEPLOY)) {
                String deploymentName = fileName.substring(0, fileName.length() - DO_DEPLOY.length());
                File deploymentFile = new File(directory, deploymentName);
                if (!deploymentFile.exists()) {
                    scanContext.ignoredMissingDeployments.add(deploymentName);
                    continue;
                }
                long timestamp = this.getDeploymentTimestamp(deploymentFile);
                String path = this.relativeTo == null ? deploymentFile.getAbsolutePath() : this.relativePath + deploymentName;
                boolean archive = deploymentFile.isFile();
                this.addContentAddingTask(path, archive, deploymentName, deploymentFile, timestamp, scanContext);
                continue;
            }
            if (fileName.endsWith(FAILED_DEPLOY)) {
                String deploymentName = fileName.substring(0, fileName.length() - FAILED_DEPLOY.length());
                scanContext.toRemove.remove(deploymentName);
                if (this.deployed.containsKey(deploymentName) || new File(child.getParent(), deploymentName).exists()) continue;
                this.removeExtraneousMarker(child, fileName);
                continue;
            }
            if (this.isEEArchive(fileName)) {
                boolean autoDeployable;
                boolean bl = autoDeployable = child.isDirectory() ? this.autoDeployExploded : this.autoDeployZip;
                if (autoDeployable) {
                    File undeployedMarker;
                    File failedMarker;
                    if (this.isAutoDeployDisabled(child) || (failedMarker = new File(directory, fileName + FAILED_DEPLOY)).exists() || (undeployedMarker = new File(directory, fileName + UNDEPLOYED)).exists()) continue;
                    DeploymentMarker marker = this.deployed.get(fileName);
                    long timestamp = this.getDeploymentTimestamp(child);
                    if (marker != null && marker.lastModified == timestamp) continue;
                    try {
                        if (this.isZipComplete(child)) {
                            String path = this.relativeTo == null ? child.getAbsolutePath() : this.relativePath + fileName;
                            boolean archive = child.isFile();
                            this.addContentAddingTask(path, archive, fileName, child, timestamp, scanContext);
                            continue;
                        }
                        scanContext.incompleteFiles.put(child, new IncompleteDeploymentStatus(child));
                    }
                    catch (ZipCompletionScanner.NonScannableZipException e) {
                        scanContext.nonscannable.put(child, e);
                    }
                    continue;
                }
                if (this.deployed.containsKey(fileName) || new File(fileName + DO_DEPLOY).exists() || new File(fileName + FAILED_DEPLOY).exists()) continue;
                scanContext.nonDeployable.add(fileName);
                continue;
            }
            if (fileName.endsWith(DEPLOYING) || fileName.endsWith(UNDEPLOYING)) {
                this.removeExtraneousMarker(child, fileName);
                continue;
            }
            if (fileName.endsWith(PENDING)) {
                String deploymentName = fileName.substring(0, fileName.length() - PENDING.length());
                File deployment = new File(child.getParent(), deploymentName);
                if (deployment.exists()) continue;
                this.removeExtraneousMarker(child, fileName);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.scanDirectory(child, scanContext);
        }
    }

    private long addContentAddingTask(String path, boolean archive, String deploymentName, File deploymentFile, long timestamp, ScanContext scanContext) {
        if (scanContext.registeredDeployments.contains(deploymentName)) {
            scanContext.scannerTasks.add(new ReplaceTask(path, archive, deploymentName, deploymentFile, timestamp));
        } else {
            scanContext.scannerTasks.add(new DeployTask(path, archive, deploymentName, deploymentFile, timestamp));
        }
        scanContext.toRemove.remove(deploymentName);
        return timestamp;
    }

    private boolean isZipComplete(File file) throws ZipCompletionScanner.NonScannableZipException {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (this.isZipComplete(child)) continue;
                return false;
            }
            return true;
        }
        if (this.isEEArchive(file.getName())) {
            try {
                return ZipCompletionScanner.isCompleteZip(file);
            }
            catch (IOException e) {
                log.error((Object)String.format("Failed checking whether %s was a complete zip", file.getPath()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean isAutoDeployDisabled(File file) {
        String name;
        File parent = file.getParentFile();
        return new File(parent, (name = file.getName()) + SKIP_DEPLOY).exists() || new File(parent, name + DO_DEPLOY).exists();
    }

    private long getDeploymentTimestamp(File deploymentFile) {
        if (deploymentFile.isDirectory()) {
            long latest = deploymentFile.lastModified();
            for (File child : deploymentFile.listFiles()) {
                long childTimestamp = this.getDeploymentTimestamp(child);
                if (childTimestamp <= latest) continue;
                latest = childTimestamp;
            }
            return latest;
        }
        return deploymentFile.lastModified();
    }

    private boolean isEEArchive(String fileName) {
        return ARCHIVE_PATTERN.matcher(fileName).matches();
    }

    private void removeExtraneousMarker(File child, String fileName) {
        if (!child.delete()) {
            log.warnf("Cannot remove extraneous deployment marker file %s", (Object)fileName);
        }
    }

    private ScanStatus handleAutoDeployFailures(ScanContext scanContext) {
        ScanStatus result = ScanStatus.PROCEED;
        boolean warnLogged = false;
        HashSet<File> noLongerIncomplete = new HashSet<File>(this.incompleteDeployments.keySet());
        noLongerIncomplete.removeAll(scanContext.incompleteFiles.keySet());
        int oldIncompleteCount = this.incompleteDeployments.size();
        this.incompleteDeployments.keySet().retainAll(scanContext.incompleteFiles.keySet());
        if (scanContext.incompleteFiles.size() > 0) {
            result = ScanStatus.RETRY;
            boolean logAll = this.incompleteDeployments.size() != oldIncompleteCount;
            long now = System.currentTimeMillis();
            for (Map.Entry entry : scanContext.incompleteFiles.entrySet()) {
                boolean newIncomplete;
                File incompleteFile = (File)entry.getKey();
                String deploymentName = incompleteFile.getName();
                IncompleteDeploymentStatus status = this.incompleteDeployments.get(incompleteFile);
                if (status == null || status.size < ((IncompleteDeploymentStatus)entry.getValue()).size) {
                    status = (IncompleteDeploymentStatus)entry.getValue();
                }
                if (now - status.timestamp > this.maxNoProgress) {
                    if (!status.warned) {
                        String suffix = this.deployed.containsKey(deploymentName) ? " A previous version of this content was deployed and remains deployed." : "";
                        String msg = String.format("Deployment content %s appears to be incomplete and is not progressing toward completion. This content cannot be auto-deployed.%s", incompleteFile, suffix, DO_DEPLOY, SKIP_DEPLOY);
                        this.writeFailedMarker(incompleteFile, new ModelNode().set(msg));
                        log.error((Object)msg);
                        status.warned = true;
                        warnLogged = true;
                        result = ScanStatus.ABORT;
                    }
                    new File(incompleteFile.getParentFile(), deploymentName + PENDING).delete();
                    continue;
                }
                boolean bl = newIncomplete = this.incompleteDeployments.put(incompleteFile, status) == null;
                if (newIncomplete || logAll) {
                    log.infof("Scan found incompletely copied file content for deployment %s. Deployment changes will not be processed until all content is complete.", (Object)((File)entry.getKey()).getPath());
                }
                if (!newIncomplete) continue;
                File pending = new File(incompleteFile.getParentFile(), deploymentName + PENDING);
                this.createMarkerFile(pending, deploymentName);
            }
        }
        for (File complete : noLongerIncomplete) {
            File pending = new File(complete.getParentFile(), complete.getName() + PENDING);
            this.removeExtraneousMarker(pending, pending.getName());
        }
        int oldNonScannableCount = this.nonscannableLogged.size();
        this.nonscannableLogged.retainAll(scanContext.nonscannable.keySet());
        if (scanContext.nonscannable.size() > 0) {
            result = result == ScanStatus.PROCEED ? ScanStatus.RETRY : result;
            boolean logAll = this.nonscannableLogged.size() != oldNonScannableCount;
            for (Map.Entry entry : scanContext.nonscannable.entrySet()) {
                File nonScannable = (File)entry.getKey();
                String fileName = nonScannable.getName();
                if (!this.nonscannableLogged.add(nonScannable) && !logAll) continue;
                ZipCompletionScanner.NonScannableZipException e = (ZipCompletionScanner.NonScannableZipException)entry.getValue();
                String msg = String.format("File %s was configured for auto-deploy but could not be safely auto-deployed. The reason the file could not be auto-deployed was: %s.  To enable deployment of this file create a file called %s%s", fileName, e.getLocalizedMessage(), fileName, DO_DEPLOY);
                this.writeFailedMarker(nonScannable, new ModelNode().set(msg));
                log.error((Object)msg);
                warnLogged = true;
                result = ScanStatus.ABORT;
            }
        }
        if (warnLogged) {
            HashSet<String> allProblems = new HashSet<String>();
            for (File file : scanContext.nonscannable.keySet()) {
                allProblems.add(file.getName());
            }
            for (File file : scanContext.incompleteFiles.keySet()) {
                allProblems.add(file.getName());
            }
            log.warnf("Scan found content configured for auto-deploy that could not be safely auto-deployed. See details above. Deployment changes will not be processed until all problematic content is either removed or whether to deploy the content or not is indicated via a %s or %s marker file. Problematic deployments are %s", (Object)DO_DEPLOY, (Object)SKIP_DEPLOY, allProblems);
        }
        return result;
    }

    private synchronized void startScan() {
        if (this.scanEnabled) {
            this.scanTask = this.scanInterval > 0L ? this.scheduledExecutor.scheduleWithFixedDelay(this.scanRunnable, 0L, this.scanInterval, TimeUnit.MILLISECONDS) : this.scheduledExecutor.schedule(this.scanRunnable, this.scanInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelScan() {
        if (this.rescanIncompleteTask != null) {
            this.rescanIncompleteTask.cancel(false);
            this.rescanIncompleteTask = null;
        }
        if (this.scanTask != null) {
            this.scanTask.cancel(false);
            this.scanTask = null;
        }
    }

    private Set<String> getDeploymentNames() throws CancellationException {
        ModelNode response;
        ModelNode op = Util.getEmptyOperation((String)"read-children-names", (ModelNode)new ModelNode());
        op.get("child-type").set("deployment");
        try {
            response = this.controllerClient.execute(op);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ModelNode result = response.get("result");
        HashSet<String> deploymentNames = new HashSet<String>();
        if (result.isDefined()) {
            List deploymentNodes = result.asList();
            for (ModelNode node : deploymentNodes) {
                deploymentNames.add(node.asString());
            }
        }
        return deploymentNames;
    }

    private ModelNode getCompositeUpdate(List<ModelNode> updates) {
        ModelNode op = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = op.get("steps");
        for (ModelNode update : updates) {
            steps.add(update);
        }
        return op;
    }

    private ModelNode getCompositeUpdate(ModelNode ... updates) {
        ModelNode op = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = op.get("steps");
        for (ModelNode update : updates) {
            steps.add(update);
        }
        return op;
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMarkerFile(File marker, String deploymentName) {
        FileOutputStream fos = null;
        try {
            marker.createNewFile();
            fos = new FileOutputStream(marker);
            fos.write(deploymentName.getBytes());
            this.safeClose(fos);
        }
        catch (IOException io) {
            try {
                log.errorf((Throwable)io, "Caught exception writing deployment marker file %s", (Object)marker.getAbsolutePath());
                this.safeClose(fos);
            }
            catch (Throwable throwable) {
                this.safeClose(fos);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFailedMarker(File deploymentFile, ModelNode failureDescription) {
        File undeployedMarker;
        File deployedMarker;
        File failedMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + FAILED_DEPLOY);
        File deployMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + DO_DEPLOY);
        if (deployMarker.exists() && !deployMarker.delete()) {
            log.warnf("Unable to remove marker file %s", (Object)deployMarker);
        }
        if ((deployedMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + DEPLOYED)).exists() && !deployedMarker.delete()) {
            log.warnf("Unable to remove marker file %s", (Object)deployedMarker);
        }
        if ((undeployedMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + UNDEPLOYED)).exists() && !undeployedMarker.delete()) {
            log.warnf("Unable to remove marker file %s", (Object)undeployedMarker);
        }
        FileOutputStream fos = null;
        try {
            failedMarker.createNewFile();
            fos = new FileOutputStream(failedMarker);
            fos.write(failureDescription.asString().getBytes());
            this.safeClose(fos);
        }
        catch (IOException io) {
            try {
                log.errorf((Throwable)io, "Caught exception writing deployment failed marker file %s", (Object)failedMarker.getAbsolutePath());
                this.safeClose(fos);
            }
            catch (Throwable throwable) {
                this.safeClose(fos);
                throw throwable;
            }
        }
    }

    private class DeploymentTask
    implements Callable<ModelNode> {
        private final Operation deploymentOp;

        private DeploymentTask(Operation deploymentOp) {
            this.deploymentOp = deploymentOp;
        }

        @Override
        public ModelNode call() {
            try {
                return FileSystemDeploymentService.this.controllerClient.execute(this.deploymentOp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static enum ScanStatus {
        ABORT,
        RETRY,
        PROCEED;

    }

    private class IncompleteDeploymentStatus {
        private final long timestamp = System.currentTimeMillis();
        private final long size;
        private boolean warned;

        IncompleteDeploymentStatus(File file) {
            this.size = file.length();
        }
    }

    private class ScanContext {
        private final Set<String> registeredDeployments;
        private final List<ScannerTask> scannerTasks;
        private final Set<String> toRemove;
        private final HashSet<String> ignoredMissingDeployments;
        private Map<File, IncompleteDeploymentStatus> incompleteFiles;
        private final HashSet<String> nonDeployable;
        private final Map<File, ZipCompletionScanner.NonScannableZipException> nonscannable;

        private ScanContext() {
            this.registeredDeployments = FileSystemDeploymentService.this.getDeploymentNames();
            this.scannerTasks = new ArrayList<ScannerTask>();
            this.toRemove = new HashSet(FileSystemDeploymentService.this.deployed.keySet());
            this.ignoredMissingDeployments = new HashSet();
            this.incompleteFiles = new HashMap<File, IncompleteDeploymentStatus>();
            this.nonDeployable = new HashSet();
            this.nonscannable = new HashMap<File, ZipCompletionScanner.NonScannableZipException>();
        }
    }

    private class DeploymentMarker {
        private long lastModified;

        private DeploymentMarker(long lastModified) {
            this.lastModified = lastModified;
        }
    }

    private final class UndeployTask
    extends ScannerTask {
        private UndeployTask(String deploymentName, File parent) {
            super(deploymentName, parent, FileSystemDeploymentService.UNDEPLOYING);
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", this.deploymentName);
            ModelNode undeployOp = Util.getEmptyOperation((String)"undeploy", (ModelNode)address);
            ModelNode removeOp = Util.getEmptyOperation((String)"remove", (ModelNode)address);
            return FileSystemDeploymentService.this.getCompositeUpdate(new ModelNode[]{undeployOp, removeOp});
        }

        @Override
        protected void handleSuccessResult() {
            this.removeInProgressMarker();
            File deployedMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.UNDEPLOYED);
            FileSystemDeploymentService.this.createMarkerFile(deployedMarker, this.deploymentName);
            FileSystemDeploymentService.this.deployed.remove(this.deploymentName);
            FileSystemDeploymentService.this.noticeLogged.remove(this.deploymentName);
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(new File(this.parent, this.deploymentName), result.get("failure-description"));
        }
    }

    private final class RedeployTask
    extends ScannerTask {
        private final long markerLastModified;

        private RedeployTask(String deploymentName, long markerLastModified, File parent) {
            super(deploymentName, parent, FileSystemDeploymentService.DEPLOYING);
            this.markerLastModified = markerLastModified;
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", this.deploymentName);
            return Util.getEmptyOperation((String)"redeploy", (ModelNode)address);
        }

        @Override
        protected void handleSuccessResult() {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.deployed.remove(this.deploymentName);
            FileSystemDeploymentService.this.deployed.put(this.deploymentName, new DeploymentMarker(this.markerLastModified));
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(new File(this.parent, this.deploymentName), result.get("failure-description"));
        }
    }

    private final class ReplaceTask
    extends ContentAddingTask {
        private ReplaceTask(String path, boolean archive, String deploymentName, File deploymentFile, long markerTimestamp) {
            super(path, archive, deploymentName, deploymentFile, markerTimestamp);
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode replaceOp = Util.getEmptyOperation((String)"full-replace-deployment", (ModelNode)new ModelNode());
            replaceOp.get("name").set(this.deploymentName);
            replaceOp.get("content").set(this.createContent());
            return replaceOp;
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(this.deploymentFile, result.get("failure-description"));
        }
    }

    private final class DeployTask
    extends ContentAddingTask {
        private DeployTask(String path, boolean archive, String deploymentName, File deploymentFile, long markerTimestamp) {
            super(path, archive, deploymentName, deploymentFile, markerTimestamp);
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", this.deploymentName);
            ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)address);
            addOp.get("content").set(this.createContent());
            addOp.get("persistent").set(false);
            ModelNode deployOp = Util.getEmptyOperation((String)"deploy", (ModelNode)address);
            return FileSystemDeploymentService.this.getCompositeUpdate(new ModelNode[]{addOp, deployOp});
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            log.error((Object)result.get("failure-description").asString());
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(this.deploymentFile, result.get("failure-description"));
        }
    }

    private abstract class ContentAddingTask
    extends ScannerTask {
        private final String path;
        private final boolean archive;
        protected final File deploymentFile;
        protected final long doDeployTimestamp;

        protected ContentAddingTask(String path, boolean archive, String deploymentName, File deploymentFile, long markerTimestamp) {
            super(deploymentName, deploymentFile.getParentFile(), FileSystemDeploymentService.DEPLOYING);
            this.path = path;
            this.archive = archive;
            this.deploymentFile = deploymentFile;
            this.doDeployTimestamp = markerTimestamp;
        }

        protected ModelNode createContent() {
            ModelNode content = new ModelNode();
            ModelNode contentItem = content.get(0);
            contentItem.get("path").set(this.path);
            if (FileSystemDeploymentService.this.relativeTo != null) {
                contentItem.get("relative-to").set(FileSystemDeploymentService.this.relativeTo);
            }
            contentItem.get("archive").set(this.archive);
            return content;
        }

        @Override
        protected void handleSuccessResult() {
            File failedMarker;
            File doDeployMarker = new File(new File(this.parent), this.deploymentFile.getName() + FileSystemDeploymentService.DO_DEPLOY);
            if (doDeployMarker.exists() && !doDeployMarker.delete()) {
                log.errorf("Failed to delete deployment marker file %s", (Object)doDeployMarker.getAbsolutePath());
            }
            if ((failedMarker = new File(this.deploymentFile.getParent(), this.deploymentFile.getName() + FileSystemDeploymentService.FAILED_DEPLOY)).exists() && !failedMarker.delete()) {
                log.warnf("Unable to remove marker file %s", (Object)failedMarker);
            }
            this.removeInProgressMarker();
            File deployedMarker = new File(this.parent, this.deploymentFile.getName() + FileSystemDeploymentService.DEPLOYED);
            FileSystemDeploymentService.this.createMarkerFile(deployedMarker, this.deploymentName);
            deployedMarker.setLastModified(this.doDeployTimestamp);
            if (FileSystemDeploymentService.this.deployed.containsKey(this.deploymentName)) {
                FileSystemDeploymentService.this.deployed.remove(this.deploymentName);
            }
            FileSystemDeploymentService.this.deployed.put(this.deploymentName, new DeploymentMarker(deployedMarker.lastModified()));
        }
    }

    private abstract class ScannerTask {
        protected final String deploymentName;
        protected final String parent;
        private final String inProgressMarkerSuffix;

        private ScannerTask(String deploymentName, File parent, String inProgressMarkerSuffix) {
            this.deploymentName = deploymentName;
            this.parent = parent.getAbsolutePath();
            this.inProgressMarkerSuffix = inProgressMarkerSuffix;
            File marker = new File(parent, deploymentName + FileSystemDeploymentService.PENDING);
            if (!marker.exists()) {
                FileSystemDeploymentService.this.createMarkerFile(marker, deploymentName);
            }
        }

        protected void recordInProgress() {
            File marker = new File(this.parent, this.deploymentName + this.inProgressMarkerSuffix);
            FileSystemDeploymentService.this.createMarkerFile(marker, this.deploymentName);
            this.deleteUndeployedMarker();
            this.deletePendingMarker();
        }

        protected abstract ModelNode getUpdate();

        protected abstract void handleSuccessResult();

        protected abstract void handleFailureResult(ModelNode var1);

        protected void deletePendingMarker() {
            File pendingMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.PENDING);
            if (pendingMarker.exists() && !pendingMarker.delete()) {
                log.warnf("Unable to remove marker file %s", (Object)pendingMarker);
            }
        }

        protected void deleteUndeployedMarker() {
            File undeployedMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.UNDEPLOYED);
            if (undeployedMarker.exists() && !undeployedMarker.delete()) {
                log.warnf("Unable to remove marker file %s", (Object)undeployedMarker);
            }
        }

        protected void removeInProgressMarker() {
            File marker = new File(new File(this.parent), this.deploymentName + this.inProgressMarkerSuffix);
            if (marker.exists() && !marker.delete()) {
                log.warnf("Cannot delete deployment progress marker file %s", (Object)marker);
            }
        }
    }
}

