/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.File;
import java.util.Set;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface DeploymentScannerLogger
extends BasicLogger {
    public static final DeploymentScannerLogger ROOT_LOGGER = (DeploymentScannerLogger)Logger.getMessageLogger(DeploymentScannerLogger.class, (String)DeploymentScannerLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15000, value="Cannot delete deployment progress marker file %s")
    public void cannotDeleteDeploymentProgressMarker(File var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15001, value="Cannot remove extraneous deployment marker file %s")
    public void cannotRemoveDeploymentMarker(String var1);

    @LogMessage(level=Logger.Level.WARN)
    public void cannotRemoveDeploymentMarker(File var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15002, value="Deployment of '%s' requested, but the deployment is not present")
    public void deploymentNotFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15003, value="Found %1$s in deployment directory. To trigger deployment create a file called %1$s%2$s")
    public void deploymentTriggered(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15004, value="Caught exception writing deployment marker file %s")
    public void errorWritingDeploymentMarker(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15005, value="Reliable deployment behaviour is not possible when auto-deployment of exploded content is enabled (i.e. deployment without use of \"%s\"' marker files). Configuration of auto-deployment of exploded content is not recommended in any situation where reliability is desired. Configuring the deployment scanner's %s setting to \"false\" is recommended.")
    public void explodedAutoDeploymentContentWarning(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15006, value="The deployment scanner found that the content for exploded deployment %1$s has been deleted, but auto-deploy/undeploy for exploded deployments is not enabled and the %1$s%2$s marker file for this deployment has not been removed. As a result, the deployment is not being undeployed, but resources needed by the deployment may have been deleted and application errors may occur. Deleting the %1$s%2$s marker file to trigger undeploy is recommended.")
    public void explodedDeploymentContentDeleted(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15007, value="Failed checking whether %s was a complete zip")
    public void failedCheckingZipFile(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15008, value="File system deployment service failed")
    public void fileSystemDeploymentFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15009, value="Scan found incompletely copied file content for deployment %s. Deployment changes will not be processed until all content is complete.")
    public void incompleteContent(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15010, value="The deployment scanner found a directory named %1$s that was not inside a directory whose name ends with .ear, .jar, .rar, .sar or .war. This is likely the result of unzipping an archive directly inside the %2$s directory, which is a user error. The %1$s directory will not be scanned for deployments, but it is possible that the scanner mayfind other files from the unzipped archive and attempt to deploy them, leading to errors.")
    public void invalidExplodedDeploymentDirectory(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15011, value="Scan of %s threw Exception")
    public void scanException(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15012, value="Started %s for directory %s")
    public void started(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15013, value="Scan found content configured for auto-deploy that could not be safely auto-deployed. See details above. Deployment changes will not be processed until all problematic content is either removed or whether to deploy the content or not is indicated via a %s or %s marker file. Problematic deployments are %s")
    public void unsafeAutoDeploy(String var1, String var2, Set<String> var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15014, value="Re-attempting failed deployment %s")
    public void reattemptingFailedDeployment(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15015, value="Failed checking whether %s was a complete XML")
    public void failedCheckingXMLFile(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15016, value="Initial deployment scan failed")
    public void initialScanFailed(@Cause Throwable var1);
}

