/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.domain.controller.DomainDeploymentHandler;

class ConcurrentUpdateTask
implements Runnable {
    private final List<Runnable> concurrentTasks;
    private final ExecutorService executorService;

    ConcurrentUpdateTask(List<Runnable> concurrentTasks, ExecutorService executorService) {
        this.concurrentTasks = concurrentTasks;
        this.executorService = executorService;
    }

    @Override
    public void run() {
        ArrayList futures = new ArrayList();
        for (Runnable r : this.concurrentTasks) {
            futures.add(this.executorService.submit(r));
        }
        for (int i = 0; i < futures.size(); ++i) {
            Future future = (Future)futures.get(i);
            try {
                future.get();
                continue;
            }
            catch (InterruptedException e) {
                DomainDeploymentHandler.logger.errorf("ConcurrentUpdateTask caught InterruptedException waiting for task %s; returning", (Object)this.concurrentTasks.get(i).toString());
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException e) {
                DomainDeploymentHandler.logger.errorf((Throwable)e, "ConcurrentUpdateTask caught ExecutionException waiting for task %s", (Object)this.concurrentTasks.get(i).toString());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConcurrentUpdateTask{tasks={");
        for (int i = 0; i < this.concurrentTasks.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.concurrentTasks.get(i).toString());
        }
        sb.append("}}");
        return sb.toString();
    }
}

