/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.domain.controller.DomainConfigurationPersister;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.Element;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLContentWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;

public class DomainConfigurationPersisterImpl
implements DomainConfigurationPersister {
    public static final String CONFIG_FILE = "domain.xml";
    public static final String BACKUP_SUFFIX = ".last-known-good";
    private static Logger logger = Logger.getLogger((String)"org.jboss.as.domain");
    private final File configFile;

    public DomainConfigurationPersisterImpl(File configDir) {
        if (configDir == null) {
            throw new IllegalArgumentException("Domain configuration directory is null");
        }
        File configFile = new File(configDir, CONFIG_FILE);
        if (configFile.exists()) {
            if (configFile.isDirectory()) {
                throw new IllegalArgumentException(configFile.getAbsolutePath() + " is a directory");
            }
        } else if (configFile.isDirectory() || !configDir.canWrite()) {
            throw new IllegalArgumentException(configFile.getAbsolutePath() + " is not a writable");
        }
        this.configFile = configFile;
    }

    @Override
    public InputStream getConfigurationInputStream() throws IOException {
        return new FileInputStream(this.configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void persistConfiguration(DomainModel domainModel) {
        block13: {
            XMLStreamWriter xmlWriter;
            BufferedOutputStream bos;
            FileOutputStream fos;
            block11: {
                fos = null;
                bos = null;
                xmlWriter = null;
                this.backupConfigFile();
                this.configFile.createNewFile();
                fos = new FileOutputStream(this.configFile);
                bos = new BufferedOutputStream(fos);
                xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(bos);
                XMLMapper mapper = XMLMapper.Factory.create();
                mapper.deparseDocument((XMLContentWriter)new RootElementWriter(domainModel), xmlWriter);
                if (xmlWriter == null) break block11;
                try {
                    xmlWriter.close();
                }
                catch (XMLStreamException e) {
                    logger.warnf((Throwable)e, "Failed closing writer to configuration file %s", (Object)this.configFile.getAbsolutePath());
                }
            }
            StreamUtils.safeClose((Closeable)bos);
            StreamUtils.safeClose((Closeable)fos);
            break block13;
            catch (Exception e) {
                block12: {
                    try {
                        logger.errorf((Throwable)e, "Failed persisting configuration file %s", (Object)this.configFile.getAbsolutePath());
                        if (xmlWriter == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (xmlWriter != null) {
                            try {
                                xmlWriter.close();
                            }
                            catch (XMLStreamException e2) {
                                logger.warnf((Throwable)e2, "Failed closing writer to configuration file %s", (Object)this.configFile.getAbsolutePath());
                            }
                        }
                        StreamUtils.safeClose(bos);
                        StreamUtils.safeClose(fos);
                        throw throwable;
                    }
                    try {
                        xmlWriter.close();
                    }
                    catch (XMLStreamException e3) {
                        logger.warnf((Throwable)e3, "Failed closing writer to configuration file %s", (Object)this.configFile.getAbsolutePath());
                    }
                }
                StreamUtils.safeClose(bos);
                StreamUtils.safeClose((Closeable)fos);
            }
        }
    }

    private void backupConfigFile() throws IOException {
        File backup = new File(this.configFile.getParent(), this.configFile.getName() + BACKUP_SUFFIX);
        DomainConfigurationPersisterImpl.copyFile(this.configFile, backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File backup) throws IOException {
        if (backup.exists()) {
            backup.delete();
        }
        if (!file.renameTo(backup)) {
            FileInputStream fis = new FileInputStream(file);
            try {
                FileOutputStream fos = new FileOutputStream(backup);
                try {
                    StreamUtils.copyStream((InputStream)fis, (OutputStream)fos);
                    fos.close();
                }
                finally {
                    StreamUtils.safeClose((Closeable)fos);
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)fis);
            }
        }
    }

    private static class RootElementWriter
    implements XMLContentWriter {
        private final DomainModel domainModel;

        private RootElementWriter(DomainModel domainModel) {
            this.domainModel = domainModel;
        }

        public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
            streamWriter.writeStartDocument();
            streamWriter.writeStartElement(Element.DOMAIN.getLocalName());
            this.domainModel.writeContent(streamWriter);
            streamWriter.writeEndDocument();
        }
    }
}

