/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.deployment.DeploymentAction;
import org.jboss.as.domain.client.api.deployment.DeploymentPlan;
import org.jboss.as.domain.client.api.deployment.DeploymentSetPlan;
import org.jboss.as.domain.client.api.deployment.IncompleteDeploymentReplaceException;
import org.jboss.as.domain.client.api.deployment.InvalidDeploymentPlanException;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentPlan;
import org.jboss.as.domain.client.impl.DomainUpdateApplierResponse;
import org.jboss.as.domain.client.impl.deployment.DeploymentActionImpl;
import org.jboss.as.domain.controller.ConcurrentGroupServerUpdatePolicy;
import org.jboss.as.domain.controller.ConcurrentUpdateTask;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.RollingUpdateTask;
import org.jboss.as.domain.controller.ServerUpdatePolicy;
import org.jboss.as.domain.controller.StreamedResponse;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DeploymentUnitElement;
import org.jboss.as.model.DomainDeploymentAdd;
import org.jboss.as.model.DomainDeploymentFullReplaceUpdate;
import org.jboss.as.model.DomainDeploymentRedeployUpdate;
import org.jboss.as.model.DomainDeploymentRemove;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainServerGroupUpdate;
import org.jboss.as.model.ServerGroupDeploymentAdd;
import org.jboss.as.model.ServerGroupDeploymentRemove;
import org.jboss.as.model.ServerGroupDeploymentReplaceUpdate;
import org.jboss.as.model.ServerGroupDeploymentStartStopUpdate;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.logging.Logger;

public class DomainDeploymentHandler {
    static Logger logger = Logger.getLogger((String)"org.jboss.as.domain.deployment");
    private final DomainController domainController;
    private final ExecutorService executorService;

    public DomainDeploymentHandler(DomainController domainController, ExecutorService executorService) {
        this.domainController = domainController;
        this.executorService = executorService;
    }

    public void executeDeploymentPlan(final DeploymentPlan plan, final BlockingQueue<List<StreamedResponse>> responseQueue) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean failed = false;
                try {
                    DomainDeploymentHandler.this.runDeploymentPlan(plan, responseQueue);
                    logger.infof("Completed deployment plan %s", (Object)plan.getId());
                }
                catch (InterruptedException e) {
                    failed = true;
                    Thread.currentThread().interrupt();
                    logger.errorf((Throwable)e, "Interrupted while executing deployment plan %s", (Object)plan.getId());
                }
                catch (Exception e) {
                    logger.errorf((Throwable)e, "Caught exception executing deployment plan %s", (Object)plan.getId());
                    failed = true;
                }
                catch (Error e) {
                    logger.errorf((Throwable)e, "Caught error executing deployment plan %s", (Object)plan.getId());
                    throw e;
                }
                if (failed) {
                    try {
                        DomainDeploymentHandler.pushSingleResponse(responseQueue, new StreamedResponse(86, null, true));
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.getDeploymentExecutor().submit(r);
    }

    private void runDeploymentPlan(DeploymentPlan plan, BlockingQueue<List<StreamedResponse>> responseQueue) throws InterruptedException {
        DomainDeploymentHandler.pushSingleResponse(responseQueue, new StreamedResponse(67, plan.getId()));
        List setPlans = plan.getDeploymentSetPlans();
        ArrayList<DeploymentSetUpdates> updateSets = new ArrayList<DeploymentSetUpdates>(setPlans.size());
        for (DeploymentSetPlan setPlan : setPlans) {
            try {
                updateSets.add(DomainDeploymentHandler.createDeploymentSetUpdates(setPlan, this.getDomainModel(), setPlan.getDeploymentActions()));
            }
            catch (InvalidDeploymentPlanException e) {
                logger.errorf((Throwable)e, "Deployment plan %s is invalid", (Object)plan.getId());
                DomainDeploymentHandler.pushSingleResponse(responseQueue, new StreamedResponse(68, (Object)e, true));
                return;
            }
        }
        ArrayList<DeploymentSetUpdates> rollbackSets = new ArrayList<DeploymentSetUpdates>(setPlans.size());
        boolean ok = true;
        boolean rollbackFailed = false;
        for (DeploymentSetUpdates updateSet : updateSets) {
            if (ok) {
                try {
                    ok = this.executeDeploymentSet(updateSet, responseQueue);
                    if (ok) {
                        rollbackSets.add(0, updateSet);
                        continue;
                    }
                    logger.debugf("Deployment set %s did not succeed", (Object)updateSet.setPlan.getId());
                }
                catch (RollbackFailedException e) {
                    ok = false;
                    rollbackFailed = true;
                    logger.errorf("Rollback of deployment set %s did not succeed", (Object)updateSet.setPlan.getId());
                }
                continue;
            }
            this.cancelDeploymentSet(updateSet, false, responseQueue);
        }
        if (plan.isGlobalRollback()) {
            if (!ok && !rollbackFailed) {
                Iterator iter = rollbackSets.iterator();
                while (iter.hasNext()) {
                    DeploymentSetUpdates updateSet;
                    updateSet = (DeploymentSetUpdates)iter.next();
                    try {
                        this.rollbackDeploymentSet(updateSet, responseQueue);
                        iter.remove();
                    }
                    catch (RollbackFailedException e) {
                        rollbackFailed = true;
                        logger.errorf("Rollback of deployment set %s did not succeed", (Object)updateSet.setPlan.getId());
                        break;
                    }
                }
            }
            if (rollbackFailed) {
                for (DeploymentSetUpdates updateSet : rollbackSets) {
                    this.cancelDeploymentSet(updateSet, true, responseQueue);
                }
            }
        }
        DomainDeploymentHandler.pushSingleResponse(responseQueue, new StreamedResponse(86, null, true));
    }

    private DomainModel getDomainModel() {
        return this.domainController.getDomainModel();
    }

    private boolean executeDeploymentSet(DeploymentSetUpdates updateSet, BlockingQueue<List<StreamedResponse>> responseQueue) throws InterruptedException, RollbackFailedException {
        logger.debugf("Executing deployment set %s", (Object)updateSet.setPlan.getId());
        List<DomainUpdateApplierResponse> rsps = this.domainController.applyUpdatesToModel(updateSet.getDomainUpdates());
        DomainDeploymentHandler.pushSingleResponse(responseQueue, new StreamedResponse(69, updateSet.setPlan.getId()));
        DeploymentAction lastResponseAction = null;
        for (int i = 0; i < rsps.size(); ++i) {
            DeploymentAction action;
            DomainUpdateApplierResponse duar = rsps.get(i);
            if (duar.getDomainFailure() == null && duar.getHostFailures().size() <= 0 && !updateSet.isLastDomainUpdateForAction(i) || (action = updateSet.getDeploymentActionForDomainUpdate(i)) == lastResponseAction) continue;
            ArrayList<StreamedResponse> rspList = new ArrayList<StreamedResponse>(2);
            rspList.add(new StreamedResponse(70, action.getId()));
            rspList.add(new StreamedResponse(71, duar));
            responseQueue.put(rspList);
            lastResponseAction = action;
        }
        DomainUpdateApplierResponse last = rsps.get(rsps.size() - 1);
        if (last.getDomainFailure() != null || last.getHostFailures().size() > 0) {
            return false;
        }
        Runnable r = this.getServerUpdateTask(updateSet, rsps, false, responseQueue);
        r.run();
        boolean ok = true;
        for (ServerUpdatePolicy policy : updateSet.updatePolicies.values()) {
            if (!policy.isFailed()) continue;
            logger.infof("Deployment set failed on %s", (Object)policy.getServerGroupName());
            ok = false;
            break;
        }
        if (!ok) {
            this.rollbackDeploymentSet(updateSet, responseQueue);
        }
        return ok;
    }

    private ExecutorService getDeploymentExecutor() {
        return this.executorService;
    }

    private void cancelDeploymentSet(DeploymentSetUpdates updateSet, boolean forRollback, BlockingQueue<List<StreamedResponse>> responseQueue) throws InterruptedException {
        byte type = forRollback ? (byte)83 : 69;
        DomainDeploymentHandler.pushSingleResponse(responseQueue, new StreamedResponse(type, updateSet.setPlan.getId()));
        ArrayList<StreamedResponse> rspList = new ArrayList<StreamedResponse>();
        DomainUpdateApplierResponse duar = new DomainUpdateApplierResponse(true);
        for (ActionUpdates au : updateSet.actionUpdates) {
            rspList.add(new StreamedResponse(70, au.action.getId()));
            rspList.add(new StreamedResponse(71, duar));
        }
        responseQueue.put(rspList);
    }

    private void rollbackDeploymentSet(DeploymentSetUpdates updateSet, BlockingQueue<List<StreamedResponse>> responseQueue) throws InterruptedException, RollbackFailedException {
        logger.debugf("Rolling back deployment set %s", (Object)updateSet.setPlan.getId());
        List<DomainUpdateApplierResponse> rsps = this.domainController.applyUpdatesToModel(updateSet.getDomainRollbacks());
        DomainDeploymentHandler.pushSingleResponse(responseQueue, new StreamedResponse(83, updateSet.setPlan.getId()));
        DeploymentAction lastResponseAction = null;
        for (int i = 0; i < rsps.size(); ++i) {
            DeploymentAction action;
            DomainUpdateApplierResponse duar = rsps.get(i);
            if (duar.getDomainFailure() == null && duar.getHostFailures().size() <= 0 && !updateSet.isLastDomainRollbackForAction(i) || (action = updateSet.getDeploymentActionForDomainUpdate(i)) == lastResponseAction) continue;
            ArrayList<StreamedResponse> rspList = new ArrayList<StreamedResponse>(2);
            rspList.add(new StreamedResponse(70, action.getId()));
            rspList.add(new StreamedResponse(71, duar));
            responseQueue.put(rspList);
            lastResponseAction = action;
        }
        DomainUpdateApplierResponse last = rsps.get(rsps.size() - 1);
        if (last.getDomainFailure() != null || last.getHostFailures().size() > 0) {
            throw new RollbackFailedException();
        }
        Runnable r = this.getServerUpdateTask(updateSet, rsps, true, responseQueue);
        r.run();
        for (ServerUpdatePolicy policy : updateSet.rollbackPolicies.values()) {
            if (!policy.isFailed()) continue;
            throw new RollbackFailedException();
        }
    }

    private Runnable getServerUpdateTask(DeploymentSetUpdates updateSet, List<DomainUpdateApplierResponse> rsps, boolean forRollbacks, BlockingQueue<List<StreamedResponse>> responseQueue) {
        logger.debugf("Creating server tasks for %s domain responses", (Object)rsps.size());
        HashMap<String, TreeSet<ServerIdentity>> serversByGroup = new HashMap<String, TreeSet<ServerIdentity>>();
        for (DomainUpdateApplierResponse duar : rsps) {
            for (ServerIdentity serverId : duar.getServers()) {
                String serverGroupName = serverId.getServerGroupName();
                TreeSet<ServerIdentity> set = (TreeSet<ServerIdentity>)serversByGroup.get(serverGroupName);
                if (set == null) {
                    logger.debugf("Found affected servers in server group %s", (Object)serverGroupName);
                    set = new TreeSet<ServerIdentity>(ServerIdentityComparator.INSTANCE);
                    serversByGroup.put(serverGroupName, set);
                }
                set.add(serverId);
            }
        }
        boolean shutdown = updateSet.setPlan.isShutdown();
        long gracefulTimeout = updateSet.setPlan.getGracefulShutdownTimeout();
        ArrayList<Runnable> masterList = new ArrayList<Runnable>();
        ConcurrentGroupServerUpdatePolicy predecessor = null;
        for (Set groupPlans : updateSet.setPlan.getServerGroupDeploymentPlans()) {
            ConcurrentGroupServerUpdatePolicy parent;
            ArrayList<Runnable> concurrentGroupsList = new ArrayList<Runnable>(groupPlans.size());
            predecessor = parent = new ConcurrentGroupServerUpdatePolicy(predecessor, groupPlans);
            for (ServerGroupDeploymentPlan groupPlan : groupPlans) {
                String serverGroupName = groupPlan.getServerGroupName();
                TreeSet<ServerIdentity> servers = (TreeSet<ServerIdentity>)serversByGroup.get(serverGroupName);
                if (servers == null) {
                    servers = new TreeSet<ServerIdentity>();
                }
                ServerUpdatePolicy policy = null;
                if (forRollbacks) {
                    policy = new ServerUpdatePolicy(parent, serverGroupName, servers);
                    updateSet.rollbackPolicies.put(serverGroupName, policy);
                } else {
                    policy = new ServerUpdatePolicy(parent, serverGroupName, servers, groupPlan);
                    updateSet.updatePolicies.put(serverGroupName, policy);
                }
                ArrayList<Runnable> groupTasks = new ArrayList<Runnable>(servers.size());
                if (shutdown) {
                    for (ServerIdentity server : servers) {
                        groupTasks.add(new ServerRestartTask(server, updateSet, forRollbacks, policy, responseQueue, gracefulTimeout));
                    }
                } else if (forRollbacks) {
                    for (ServerIdentity server : servers) {
                        ArrayList<AbstractServerModelUpdate> serverRollbacks = null;
                        List origResults = (List)updateSet.serverResults.get(server);
                        if (origResults == null) {
                            serverRollbacks = updateSet.getServerRollbacks();
                        } else {
                            serverRollbacks = new ArrayList<AbstractServerModelUpdate>();
                            boolean rollingBack = false;
                            for (int i = origResults.size() - 1; i >= 0; --i) {
                                UpdateResultHandlerResponse origResult = (UpdateResultHandlerResponse)origResults.get(i);
                                if (!rollingBack) {
                                    boolean bl = rollingBack = !origResult.isCancelled() && !origResult.isRolledBack();
                                }
                                if (!rollingBack) continue;
                                serverRollbacks.add(updateSet.getRollbackUpdateForServerUpdate(i));
                            }
                        }
                        if (serverRollbacks.size() <= 0) continue;
                        groupTasks.add(new RunningServerUpdateTask(server, updateSet, serverRollbacks, policy, responseQueue));
                    }
                } else {
                    for (ServerIdentity server : servers) {
                        groupTasks.add(new RunningServerUpdateTask(server, updateSet, policy, responseQueue, groupPlan.isRollback()));
                    }
                }
                if (groupPlan.isRollingToServers()) {
                    concurrentGroupsList.add(new RollingUpdateTask(groupTasks));
                    continue;
                }
                concurrentGroupsList.add(new ConcurrentUpdateTask(groupTasks, this.getDeploymentExecutor()));
            }
            masterList.add(new ConcurrentUpdateTask(concurrentGroupsList, this.getDeploymentExecutor()));
        }
        return new RollingUpdateTask(masterList);
    }

    private static void pushSingleResponse(BlockingQueue<List<StreamedResponse>> queue, StreamedResponse response) throws InterruptedException {
        queue.put(Collections.singletonList(response));
    }

    private static DeploymentSetUpdates createDeploymentSetUpdates(DeploymentSetPlan plan, DomainModel model, List<DeploymentAction> actions) throws InvalidDeploymentPlanException {
        logger.debugf("Creating DeploymentSetUpdates for deployment set %s", (Object)plan.getId());
        if (actions.size() == 0) {
            throw new InvalidDeploymentPlanException(String.format("%s %s contains no deployment actions", DeploymentSetPlan.class.getSimpleName(), plan.getId()));
        }
        ArrayList<ActionUpdates> actionUpdates = new ArrayList<ActionUpdates>();
        block12: for (DeploymentAction action : actions) {
            ActionUpdates au = new ActionUpdates(action);
            actionUpdates.add(au);
            try {
                DeploymentActionImpl dai = (DeploymentActionImpl)action;
                switch (action.getType()) {
                    case ADD: {
                        String deploymentName = dai.getDeploymentUnitUniqueName();
                        logger.tracef("Add of deployment %s", (Object)deploymentName);
                        String runtimeName = dai.getNewContentFileName();
                        byte[] hash = dai.getNewContentHash();
                        if (runtimeName == null) {
                            DeploymentUnitElement de = model.getDeployment(deploymentName);
                            if (de == null) {
                                throw new InvalidDeploymentPlanException("Unknown deployment unit " + deploymentName);
                            }
                            runtimeName = de.getRuntimeName();
                            hash = de.getSha1Hash();
                        } else if (model.getDeployment(deploymentName) == null) {
                            DomainDeploymentAdd dda = new DomainDeploymentAdd(deploymentName, runtimeName, hash, false);
                            au.domainUpdates.add(new DomainUpdate((AbstractDomainModelUpdate)dda, model, true));
                        }
                        ServerGroupDeploymentAdd sgda = new ServerGroupDeploymentAdd(deploymentName, runtimeName, hash, false);
                        DomainDeploymentHandler.addServerGroupUpdates(plan, au, sgda, model);
                        break;
                    }
                    case DEPLOY: {
                        logger.tracef("Deploy of deployment %s", (Object)dai.getDeploymentUnitUniqueName());
                        ServerGroupDeploymentStartStopUpdate sgdssu = new ServerGroupDeploymentStartStopUpdate(dai.getDeploymentUnitUniqueName(), true);
                        DomainDeploymentHandler.addServerGroupUpdates(plan, au, sgdssu, model);
                        break;
                    }
                    case FULL_REPLACE: {
                        logger.tracef("Full replace of deployment %s", (Object)dai.getDeploymentUnitUniqueName());
                        String deploymentName = dai.getDeploymentUnitUniqueName();
                        Set names = new LinkedHashSet(model.getServerGroupNames());
                        for (Set ssgp : plan.getServerGroupDeploymentPlans()) {
                            for (ServerGroupDeploymentPlan sgdp : ssgp) {
                                names.remove(sgdp.getServerGroupName());
                            }
                        }
                        Iterator it = names.iterator();
                        while (it.hasNext()) {
                            String name = (String)it.next();
                            ServerGroupElement sge = model.getServerGroup(name);
                            if (sge.getDeployment(dai.getDeploymentUnitUniqueName()) != null) continue;
                            it.remove();
                        }
                        if (names.size() > 0) {
                            throw new IncompleteDeploymentReplaceException(deploymentName, names.toArray(new String[names.size()]));
                        }
                        DeploymentUnitElement deployment = model.getDeployment(dai.getDeploymentUnitUniqueName());
                        boolean start = deployment != null && deployment.isStart();
                        DomainDeploymentFullReplaceUpdate ddfru = new DomainDeploymentFullReplaceUpdate(deploymentName, dai.getNewContentFileName(), dai.getNewContentHash(), start);
                        au.domainUpdates.add(new DomainUpdate((AbstractDomainModelUpdate)ddfru, model, true));
                        break;
                    }
                    case REDEPLOY: {
                        logger.tracef("Redeploy of deployment %s", (Object)dai.getDeploymentUnitUniqueName());
                        DomainDeploymentRedeployUpdate ddru = new DomainDeploymentRedeployUpdate(dai.getDeploymentUnitUniqueName());
                        au.domainUpdates.add(new DomainUpdate((AbstractDomainModelUpdate)ddru, model, true));
                        break;
                    }
                    case REMOVE: {
                        logger.tracef("Remove of deployment %s", (Object)dai.getDeploymentUnitUniqueName());
                        ServerGroupDeploymentRemove sgdr = new ServerGroupDeploymentRemove(dai.getDeploymentUnitUniqueName());
                        DomainDeploymentHandler.addServerGroupUpdates(plan, au, sgdr, model);
                        Set names = model.getServerGroupNames();
                        for (Set ssgp : plan.getServerGroupDeploymentPlans()) {
                            for (ServerGroupDeploymentPlan sgdp : ssgp) {
                                names.remove(sgdp.getServerGroupName());
                            }
                        }
                        boolean left = false;
                        for (String name : names) {
                            ServerGroupElement sge = model.getServerGroup(name);
                            if (sge.getDeployment(dai.getDeploymentUnitUniqueName()) == null) continue;
                            left = true;
                            break;
                        }
                        if (left) continue block12;
                        DomainDeploymentRemove ddr = new DomainDeploymentRemove(dai.getDeploymentUnitUniqueName());
                        au.domainUpdates.add(new DomainUpdate((AbstractDomainModelUpdate)ddr, model, true));
                        break;
                    }
                    case REPLACE: {
                        logger.tracef("Replace of deployment %s", (Object)dai.getDeploymentUnitUniqueName());
                        ServerGroupDeploymentReplaceUpdate sgdru = new ServerGroupDeploymentReplaceUpdate(dai.getDeploymentUnitUniqueName(), dai.getNewContentFileName(), dai.getNewContentHash(), dai.getReplacedDeploymentUnitUniqueName());
                        DomainDeploymentHandler.addServerGroupUpdates(plan, au, sgdru, model);
                        break;
                    }
                    case UNDEPLOY: {
                        logger.tracef("Undeploy of deployment %s", (Object)dai.getDeploymentUnitUniqueName());
                        ServerGroupDeploymentStartStopUpdate sgdssu = new ServerGroupDeploymentStartStopUpdate(dai.getDeploymentUnitUniqueName(), false);
                        DomainDeploymentHandler.addServerGroupUpdates(plan, au, sgdssu, model);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unknown %s %s", DeploymentAction.class.getSimpleName(), action.getType()));
                    }
                }
            }
            catch (InvalidDeploymentPlanException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidDeploymentPlanException(String.format("Deployment action %s of type %s primarily affecting deployment %s is invalid", action.getId(), action.getType(), action.getDeploymentUnitUniqueName()), e);
            }
        }
        logger.debugf("Created %s action updates", (Object)actionUpdates.size());
        return new DeploymentSetUpdates(actionUpdates, plan);
    }

    private static void addServerGroupUpdates(DeploymentSetPlan plan, ActionUpdates au, AbstractModelUpdate<ServerGroupElement, ?> serverGroupUpdate, DomainModel model) {
        boolean setSMU = true;
        for (Set ssgp : plan.getServerGroupDeploymentPlans()) {
            for (ServerGroupDeploymentPlan sgdp : ssgp) {
                DomainServerGroupUpdate dmu = DomainServerGroupUpdate.create((String)sgdp.getServerGroupName(), serverGroupUpdate);
                DomainUpdate du = new DomainUpdate((AbstractDomainModelUpdate)dmu, model, setSMU);
                au.domainUpdates.add(du);
                setSMU = setSMU && du.serverUpdate == null;
            }
        }
    }

    private static class ServerUpdate {
        private final AbstractServerModelUpdate<?> update;
        private final AbstractServerModelUpdate<?> compensatingUpdate;

        private ServerUpdate(AbstractServerModelUpdate<?> update, AbstractServerModelUpdate<?> compensatingUpdate) {
            this.update = update;
            this.compensatingUpdate = compensatingUpdate;
        }
    }

    private static class DomainUpdate {
        private final AbstractDomainModelUpdate<?> update;
        private final AbstractDomainModelUpdate<?> compensatingUpdate;
        private final ServerUpdate serverUpdate;

        private DomainUpdate(AbstractDomainModelUpdate<?> update, DomainModel model, boolean createServerUpdate) {
            this.update = update;
            this.compensatingUpdate = update.getCompensatingUpdate(model);
            if (createServerUpdate) {
                AbstractServerModelUpdate smu = update.getServerModelUpdate();
                if (smu != null) {
                    AbstractServerModelUpdate csmu = this.compensatingUpdate == null ? null : this.compensatingUpdate.getServerModelUpdate();
                    this.serverUpdate = new ServerUpdate(smu, csmu);
                } else {
                    this.serverUpdate = null;
                }
            } else {
                this.serverUpdate = null;
            }
        }
    }

    private static class RollbackFailedException
    extends Exception {
        private static final long serialVersionUID = 3524620474555254562L;

        private RollbackFailedException() {
        }
    }

    private static class ServerIdentityComparator
    implements Comparator<ServerIdentity> {
        private static final ServerIdentityComparator INSTANCE = new ServerIdentityComparator();

        private ServerIdentityComparator() {
        }

        @Override
        public int compare(ServerIdentity o1, ServerIdentity o2) {
            int val = o1.getHostName().compareTo(o2.getHostName());
            if (val == 0) {
                val = o1.getServerName().compareTo(o2.getServerName());
            }
            return val;
        }
    }

    private class ServerRestartTask
    extends AbstractServerUpdateTask {
        private final long gracefulTimeout;

        private ServerRestartTask(ServerIdentity serverId, DeploymentSetUpdates updates, boolean forRollback, ServerUpdatePolicy updatePolicy, BlockingQueue<List<StreamedResponse>> responseQueue, long gracefulTimeout) {
            super(serverId, updates, forRollback, updatePolicy, responseQueue);
            this.gracefulTimeout = gracefulTimeout;
        }

        @Override
        protected void processUpdates() {
            UpdateResultHandlerResponse<?> urhr = DomainDeploymentHandler.this.domainController.restartServer(this.serverId, this.gracefulTimeout);
            List<UpdateResultHandlerResponse<?>> rsps = Collections.singletonList(urhr);
            this.updates.serverResults.put(this.serverId, rsps);
            this.updatePolicy.recordServerResult(this.serverId, rsps);
            for (ActionUpdates au : this.updates.actionUpdates) {
                this.sendServerUpdateResult(au.action.getId(), urhr);
                if (!Thread.interrupted()) continue;
                break;
            }
        }
    }

    private class RunningServerUpdateTask
    extends AbstractServerUpdateTask {
        private final boolean allowOverallRollback;
        private final List<AbstractServerModelUpdate<?>> serverUpdates;

        private RunningServerUpdateTask(ServerIdentity serverId, DeploymentSetUpdates updates, ServerUpdatePolicy updatePolicy, BlockingQueue<List<StreamedResponse>> responseQueue, boolean allowOverallRollback) {
            super(serverId, updates, false, updatePolicy, responseQueue);
            this.allowOverallRollback = allowOverallRollback;
            this.serverUpdates = updates.getServerUpdates();
        }

        private RunningServerUpdateTask(ServerIdentity serverId, DeploymentSetUpdates updates, List<AbstractServerModelUpdate<?>> serverUpdates, ServerUpdatePolicy updatePolicy, BlockingQueue<List<StreamedResponse>> responseQueue) {
            super(serverId, updates, true, updatePolicy, responseQueue);
            this.allowOverallRollback = false;
            this.serverUpdates = serverUpdates;
        }

        @Override
        protected void processUpdates() {
            try {
                logger.debugf("Applying %s updates to  %s", (Object)this.updates.getServerUpdates().size(), (Object)this.serverId);
                List<UpdateResultHandlerResponse<?>> rsps = DomainDeploymentHandler.this.domainController.applyUpdatesToServer(this.serverId, this.serverUpdates, this.allowOverallRollback);
                if (!this.forRollback) {
                    this.updates.serverResults.put(this.serverId, rsps);
                }
                this.updatePolicy.recordServerResult(this.serverId, rsps);
                DeploymentAction lastResponseAction = null;
                for (int i = 0; i < rsps.size(); ++i) {
                    DeploymentAction action;
                    boolean sendResponse;
                    UpdateResultHandlerResponse<?> urhr = rsps.get(i);
                    boolean bl = sendResponse = urhr.getFailureResult() != null;
                    if (!sendResponse) {
                        boolean bl2 = sendResponse = this.forRollback ? this.updates.isLastServerRollbackUpdateForAction(i) : this.updates.isLastServerUpdateForAction(i);
                    }
                    if (!sendResponse) continue;
                    DeploymentAction deploymentAction = action = this.forRollback ? this.updates.getDeploymentActionForServerRollbackUpdate(i) : this.updates.getDeploymentActionForServerUpdate(i);
                    if (action == lastResponseAction) continue;
                    this.sendServerUpdateResult(action.getId(), urhr);
                    lastResponseAction = action;
                }
            }
            catch (Exception e) {
                logger.errorf((Throwable)e, "Caught exception applying updates to %s", (Object)this.serverId);
            }
        }
    }

    private abstract class AbstractServerUpdateTask
    implements Runnable {
        protected final ServerUpdatePolicy updatePolicy;
        protected final ServerIdentity serverId;
        protected final DeploymentSetUpdates updates;
        protected final BlockingQueue<List<StreamedResponse>> responseQueue;
        protected final boolean forRollback;

        AbstractServerUpdateTask(ServerIdentity serverId, DeploymentSetUpdates updates, boolean forRollback, ServerUpdatePolicy updatePolicy, BlockingQueue<List<StreamedResponse>> responseQueue) {
            this.serverId = serverId;
            this.updatePolicy = updatePolicy;
            this.responseQueue = responseQueue;
            this.updates = updates;
            this.forRollback = forRollback;
        }

        @Override
        public void run() {
            if (this.updatePolicy.canUpdateServer(this.serverId)) {
                this.processUpdates();
            } else {
                this.sendCancelledResponses();
            }
        }

        protected abstract void processUpdates();

        private void sendCancelledResponses() {
            UpdateResultHandlerResponse urhr = UpdateResultHandlerResponse.createCancellationResponse();
            for (ActionUpdates au : this.updates.actionUpdates) {
                this.sendServerUpdateResult(au.action.getId(), urhr);
                if (!Thread.interrupted()) continue;
                break;
            }
        }

        protected void sendServerUpdateResult(UUID actionId, UpdateResultHandlerResponse<?> urhr) {
            ArrayList<StreamedResponse> responses = new ArrayList<StreamedResponse>();
            byte type = this.forRollback ? (byte)85 : 72;
            responses.add(new StreamedResponse(type, actionId));
            responses.add(new StreamedResponse(73, this.serverId.getHostName()));
            responses.add(new StreamedResponse(80, this.serverId.getServerGroupName()));
            responses.add(new StreamedResponse(81, this.serverId.getServerName()));
            responses.add(new StreamedResponse(82, urhr));
            try {
                this.responseQueue.put(responses);
            }
            catch (InterruptedException e) {
                logger.errorf("%s interrupted sending server update responses for %s %s", (Object)this.toString(), (Object)DeploymentSetPlan.class.getSimpleName(), (Object)this.updates.setPlan.getId());
                Thread.currentThread().interrupt();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append("{server=");
            sb.append(this.serverId.getServerName());
            sb.append("}");
            return sb.toString();
        }
    }

    private static class ActionUpdates {
        private final DeploymentAction action;
        private final List<DomainUpdate> domainUpdates = new ArrayList<DomainUpdate>();

        private ActionUpdates(DeploymentAction action) {
            this.action = action;
        }
    }

    private static class DeploymentSetUpdates {
        private final List<ActionUpdates> actionUpdates;
        private final DeploymentSetPlan setPlan;
        private final Map<ServerIdentity, List<UpdateResultHandlerResponse<?>>> serverResults = new ConcurrentHashMap();
        private final Map<String, ServerUpdatePolicy> updatePolicies = new HashMap<String, ServerUpdatePolicy>();
        private final Map<String, ServerUpdatePolicy> rollbackPolicies = new HashMap<String, ServerUpdatePolicy>();

        private DeploymentSetUpdates(List<ActionUpdates> actionUpdates, DeploymentSetPlan setPlan) {
            this.actionUpdates = actionUpdates;
            this.setPlan = setPlan;
        }

        private List<AbstractDomainModelUpdate<?>> getDomainUpdates() {
            ArrayList result = new ArrayList();
            for (ActionUpdates au : this.actionUpdates) {
                for (DomainUpdate du : au.domainUpdates) {
                    result.add(du.update);
                }
            }
            return result;
        }

        private List<AbstractServerModelUpdate<?>> getServerUpdates() {
            ArrayList result = new ArrayList();
            for (ActionUpdates au : this.actionUpdates) {
                for (DomainUpdate du : au.domainUpdates) {
                    if (du.serverUpdate == null) continue;
                    result.add(du.serverUpdate.update);
                }
            }
            return result;
        }

        private List<AbstractDomainModelUpdate<?>> getDomainRollbacks() {
            ArrayList result = new ArrayList();
            for (ActionUpdates au : this.actionUpdates) {
                for (DomainUpdate du : au.domainUpdates) {
                    if (du.compensatingUpdate == null) continue;
                    result.add(du.compensatingUpdate);
                }
            }
            return result;
        }

        private List<AbstractServerModelUpdate<?>> getServerRollbacks() {
            ArrayList result = new ArrayList();
            for (ActionUpdates au : this.actionUpdates) {
                for (DomainUpdate du : au.domainUpdates) {
                    if (du.serverUpdate == null || du.serverUpdate.compensatingUpdate == null) continue;
                    result.add(du.serverUpdate.compensatingUpdate);
                }
            }
            return result;
        }

        private boolean isLastDomainUpdateForAction(int index) {
            int count = 0;
            for (ActionUpdates au : this.actionUpdates) {
                if (index >= (count += au.domainUpdates.size())) continue;
                return index == count - 1;
            }
            throw new IndexOutOfBoundsException(index + " is larger than the index of the last domain update (" + (this.getDomainUpdates().size() - 1) + ")");
        }

        private boolean isLastDomainRollbackForAction(int index) {
            int count = 0;
            for (int i = this.actionUpdates.size() - 1; i >= 0; --i) {
                ActionUpdates au = this.actionUpdates.get(i);
                int rbCount = 0;
                for (DomainUpdate du : au.domainUpdates) {
                    if (du.compensatingUpdate == null) continue;
                    ++rbCount;
                }
                if (index >= (count += rbCount)) continue;
                return index == count - 1;
            }
            throw new IndexOutOfBoundsException(index + " is larger than the index of the last domain rollback update (" + (this.getDomainRollbacks().size() - 1) + ")");
        }

        private DeploymentAction getDeploymentActionForDomainUpdate(int index) {
            int count = 0;
            for (ActionUpdates au : this.actionUpdates) {
                if (index >= (count += au.domainUpdates.size())) continue;
                return au.action;
            }
            throw new IndexOutOfBoundsException(index + " is larger than the index of the last domain update (" + (this.getDomainUpdates().size() - 1) + ")");
        }

        private boolean isLastServerUpdateForAction(int index) {
            int count = 0;
            for (ActionUpdates au : this.actionUpdates) {
                int suCount = 0;
                for (DomainUpdate du : au.domainUpdates) {
                    if (du.serverUpdate == null) continue;
                    ++suCount;
                }
                if (index >= (count += suCount)) continue;
                return index == count - 1;
            }
            throw new IndexOutOfBoundsException(index + " is larger than the index of the last server update (" + (this.getServerUpdates().size() - 1) + ")");
        }

        private boolean isLastServerRollbackUpdateForAction(int index) {
            int count = 0;
            for (int i = this.actionUpdates.size() - 1; i >= 0; --i) {
                ActionUpdates au = this.actionUpdates.get(i);
                int suCount = 0;
                for (DomainUpdate du : au.domainUpdates) {
                    if (du.serverUpdate == null || du.serverUpdate.compensatingUpdate == null) continue;
                    ++suCount;
                }
                if (index >= (count += suCount)) continue;
                return index == count - 1;
            }
            throw new IndexOutOfBoundsException(index + " is larger than the index of the last server rollback update (" + (this.getServerRollbacks().size() - 1) + ")");
        }

        private DeploymentAction getDeploymentActionForServerUpdate(int index) {
            int count = 0;
            for (ActionUpdates au : this.actionUpdates) {
                int suCount = 0;
                for (DomainUpdate du : au.domainUpdates) {
                    if (du.serverUpdate == null) continue;
                    ++suCount;
                }
                if (index >= (count += suCount)) continue;
                return au.action;
            }
            throw new IndexOutOfBoundsException(index + " is larger than the index of the last server update (" + (this.getServerUpdates().size() - 1) + ")");
        }

        private DeploymentAction getDeploymentActionForServerRollbackUpdate(int index) {
            int count = 0;
            for (ActionUpdates au : this.actionUpdates) {
                int suCount = 0;
                for (DomainUpdate du : au.domainUpdates) {
                    if (du.serverUpdate == null || du.serverUpdate.compensatingUpdate == null) continue;
                    ++suCount;
                }
                if (index >= (count += suCount)) continue;
                return au.action;
            }
            throw new IndexOutOfBoundsException(index + " is larger than the index of the last server update (" + (this.getServerUpdates().size() - 1) + ")");
        }

        private AbstractServerModelUpdate<?> getRollbackUpdateForServerUpdate(int index) {
            int count = 0;
            for (ActionUpdates au : this.actionUpdates) {
                for (DomainUpdate du : au.domainUpdates) {
                    if (du.serverUpdate == null || index != count++) continue;
                    return du.serverUpdate.compensatingUpdate;
                }
            }
            throw new IndexOutOfBoundsException(index + " is larger than the index of the last domain update (" + (this.getServerUpdates().size() - 1) + ")");
        }
    }
}

