/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.as.model.DeploymentUnitElement;
import org.jboss.logging.Logger;

public class DomainDeploymentRepository {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.domain.controller");
    private static final String CONTENT = "content";
    private File repoRoot;
    private MessageDigest messageDigest;

    public DomainDeploymentRepository(File deployDir) {
        if (deployDir == null) {
            throw new IllegalArgumentException("deployDir is null");
        }
        if (deployDir.exists()) {
            if (!deployDir.isDirectory()) {
                throw new IllegalStateException("Deployment repository root " + deployDir.getAbsolutePath() + " is not a directory");
            }
            if (!deployDir.canWrite()) {
                throw new IllegalStateException("Deployment repository root " + deployDir.getAbsolutePath() + " is not a writable");
            }
        } else if (!deployDir.mkdirs()) {
            throw new IllegalStateException("Failed to create a directory at " + deployDir.getAbsolutePath());
        }
        this.repoRoot = deployDir;
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot obtain SHA-1 " + MessageDigest.class.getSimpleName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] addDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException {
        log.debugf("Adding content with name %s", (Object)name);
        byte[] sha1Bytes = null;
        File tmp = File.createTempFile(name, "tmp", this.repoRoot);
        FileOutputStream fos = new FileOutputStream(tmp);
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            this.messageDigest.reset();
            try {
                int read;
                DigestOutputStream dos = new DigestOutputStream(fos, this.messageDigest);
                BufferedInputStream bis = new BufferedInputStream(stream);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    dos.write(bytes, 0, read);
                }
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception ignored) {}
            }
            sha1Bytes = this.messageDigest.digest();
        }
        String sha1 = DeploymentUnitElement.bytesToHexString((byte[])sha1Bytes);
        String partA = sha1.substring(0, 2);
        String partB = sha1.substring(2);
        File base = new File(this.repoRoot, partA);
        this.validateDir(base);
        File realDir = new File(base, partB);
        if (!realDir.exists() && !realDir.mkdirs()) {
            throw new IllegalStateException("Cannot create directory " + realDir.getAbsolutePath());
        }
        File realFile = new File(realDir, CONTENT);
        if (realFile.exists()) {
            if (!tmp.delete()) {
                tmp.deleteOnExit();
            }
            log.debugf("Content with name %s was already present in repository at location %s", (Object)name, (Object)realFile.getAbsolutePath());
        } else {
            this.moveTempToPermanent(tmp, realFile);
            log.infof("Content with name %s added at location %s", (Object)name, (Object)realFile.getAbsolutePath());
        }
        return sha1Bytes;
    }

    private void validateDir(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IllegalStateException("Cannot create directory " + dir.getAbsolutePath());
            }
        } else {
            if (!dir.isDirectory()) {
                throw new IllegalStateException(dir.getAbsolutePath() + " is not a directory");
            }
            if (!dir.canWrite()) {
                throw new IllegalStateException("Cannot write to directory " + dir.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTempToPermanent(File tmpFile, File permanentFile) throws IOException {
        if (!tmpFile.renameTo(permanentFile)) {
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            FileInputStream fis = null;
            try {
                int read;
                fos = new FileOutputStream(permanentFile);
                bos = new BufferedOutputStream(fos);
                fis = new FileInputStream(tmpFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    ((BufferedOutputStream)bos).write(bytes, 0, read);
                }
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception ignored) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception ignored) {}
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ignored) {}
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
            }
        }
    }
}

