/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.List;
import java.util.Set;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentPlan;
import org.jboss.as.domain.controller.ConcurrentGroupServerUpdatePolicy;
import org.jboss.as.model.UpdateResultHandlerResponse;

class ServerUpdatePolicy {
    private final ConcurrentGroupServerUpdatePolicy parent;
    private final String serverGroupName;
    private final Set<ServerIdentity> servers;
    private int successCount;
    private int failureCount;
    private final int maxFailed;

    ServerUpdatePolicy(ConcurrentGroupServerUpdatePolicy parent, String serverGroupName, Set<ServerIdentity> servers, ServerGroupDeploymentPlan groupPlan) {
        assert (parent != null) : "parent is null";
        assert (serverGroupName != null) : "serverGroupName is null";
        assert (servers != null) : "servers is null";
        assert (groupPlan != null) : "groupPlan is null";
        this.parent = parent;
        this.serverGroupName = serverGroupName;
        this.servers = servers;
        this.maxFailed = groupPlan.getMaxServerFailurePercentage() > 0 ? servers.size() * groupPlan.getMaxServerFailurePercentage() / 100 : groupPlan.getMaxServerFailures();
    }

    ServerUpdatePolicy(ConcurrentGroupServerUpdatePolicy parent, String serverGroupName, Set<ServerIdentity> servers) {
        assert (parent != null) : "parent is null";
        assert (serverGroupName != null) : "serverGroupName is null";
        assert (servers != null) : "servers is null";
        this.parent = parent;
        this.serverGroupName = serverGroupName;
        this.servers = servers;
        this.maxFailed = servers.size();
    }

    public String getServerGroupName() {
        return this.serverGroupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUpdateServer(ServerIdentity server) {
        if (!this.serverGroupName.equals(server.getServerGroupName()) || !this.servers.contains(server)) {
            throw new IllegalStateException("Unknown server " + server);
        }
        if (!this.parent.canChildProceed()) {
            return false;
        }
        ServerUpdatePolicy serverUpdatePolicy = this;
        synchronized (serverUpdatePolicy) {
            return this.failureCount <= this.maxFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordServerResult(ServerIdentity server, List<UpdateResultHandlerResponse<?>> responses) {
        if (!this.serverGroupName.equals(server.getServerGroupName()) || !this.servers.contains(server)) {
            throw new IllegalStateException("Unknown server " + server);
        }
        UpdateResultHandlerResponse<?> last = responses.size() == 0 ? null : responses.get(responses.size() - 1);
        boolean serverFailed = last != null && (last.isCancelled() || last.isRolledBack() || last.isTimedOut() || last.getFailureResult() != null);
        ServerUpdatePolicy serverUpdatePolicy = this;
        synchronized (serverUpdatePolicy) {
            int previousFailed = this.failureCount++;
            if (!serverFailed) {
                ++this.successCount;
            }
            if (previousFailed <= this.maxFailed) {
                if (!serverFailed && this.successCount + this.failureCount == this.servers.size()) {
                    this.parent.recordServerGroupResult(this.serverGroupName, false);
                } else if (serverFailed && this.failureCount > this.maxFailed) {
                    this.parent.recordServerGroupResult(this.serverGroupName, true);
                }
            }
        }
    }

    public synchronized boolean isFailed() {
        return this.failureCount > this.maxFailed;
    }
}

