/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.dmr.ModelNode;

public class DomainRootDescription {
    private static final String RESOURCE_NAME = DomainRootDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getDescription(Locale locale) {
        ResourceBundle bundle = DomainRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("domain"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        root.get(new String[]{"attributes", "namespaces"}).set(CommonDescriptions.getNamespacePrefixAttribute((Locale)locale));
        root.get(new String[]{"attributes", "schema-locations"}).set(CommonDescriptions.getSchemaLocationAttribute((Locale)locale));
        root.get("operations").setEmptyObject();
        root.get(new String[]{"children", "extension", "description"}).set(bundle.getString("domain.extension"));
        root.get(new String[]{"children", "extension", "min-occurs"}).set(0);
        root.get(new String[]{"children", "extension", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "extension", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "path", "description"}).set(bundle.getString("domain.path"));
        root.get(new String[]{"children", "path", "min-occurs"}).set(0);
        root.get(new String[]{"children", "path", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "path", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "profile", "description"}).set(bundle.getString("domain.profile"));
        root.get(new String[]{"children", "profile", "min-occurs"}).set(1);
        root.get(new String[]{"children", "profile", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "profile", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "interface", "description"}).set(bundle.getString("domain.interface"));
        root.get(new String[]{"children", "interface", "min-occurs"}).set(0);
        root.get(new String[]{"children", "interface", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "interface", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "socket-binding-group", "description"}).set(bundle.getString("domain.socket-binding-group"));
        root.get(new String[]{"children", "socket-binding-group", "min-occurs"}).set(0);
        root.get(new String[]{"children", "socket-binding-group", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "socket-binding-group", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "system-property", "description"}).set(bundle.getString("domain.system-property"));
        root.get(new String[]{"children", "system-property", "min-occurs"}).set(0);
        root.get(new String[]{"children", "system-property", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "system-property", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "deployment", "description"}).set(bundle.getString("domain.deployment"));
        root.get(new String[]{"children", "deployment", "min-occurs"}).set(0);
        root.get(new String[]{"children", "deployment", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "deployment", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "server-group", "description"}).set(bundle.getString("domain.server-group"));
        root.get(new String[]{"children", "server-group", "min-occurs"}).set(0);
        root.get(new String[]{"children", "server-group", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "server-group", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "host", "description"}).set(bundle.getString("domain.host"));
        root.get(new String[]{"children", "host", "min-occurs"}).set(0);
        root.get(new String[]{"children", "host", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "host", "model-description"}).setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

