/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class ProfileDescribeHandler
implements ModelQueryOperationHandler {
    public static final ProfileDescribeHandler INSTANCE = new ProfileDescribeHandler();

    private ProfileDescribeHandler() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode newOpResult;
        ModelNode newOp;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ModelNode result = new ModelNode();
        ModelNode profile = context.getSubModel();
        result.setEmptyList();
        if (profile.hasDefined("includes")) {
            for (ModelNode include : profile.get("includes").asList()) {
                ModelNode includeAddress = address.subAddress(0, address.size() - 1).append(new PathElement[]{PathElement.pathElement((String)"profile", (String)include.asString())}).toModelNode();
                newOp = operation.clone();
                newOp.get("address").set(includeAddress);
                newOpResult = context.getController().execute(OperationBuilder.Factory.create((ModelNode)newOp).build());
                if ("failed".equals(newOpResult.get("outcome").asString())) {
                    throw new OperationFailedException(newOpResult.get("failure-description"));
                }
                for (ModelNode op : newOpResult.require("result").asList()) {
                    result.add(op);
                }
            }
        }
        if (profile.hasDefined("subsystem")) {
            for (String subsystemName : profile.get("subsystem").keys()) {
                ModelNode subsystemAddress = address.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystemName)}).toModelNode();
                newOp = operation.clone();
                newOp.get("address").set(subsystemAddress);
                newOpResult = context.getController().execute(OperationBuilder.Factory.create((ModelNode)newOp).build());
                if ("failed".equals(newOpResult.get("outcome").asString())) {
                    throw new OperationFailedException(newOpResult.get("failure-description"));
                }
                for (ModelNode op : newOpResult.require("result").asList()) {
                    result.add(op);
                }
            }
        }
        resultHandler.handleResultFragment(Util.NO_LOCATION, result);
        resultHandler.handleResultComplete();
        return new BasicOperationResult();
    }
}

