/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.domain.controller.operations.deployment.DeploymentAddHandler;
import org.jboss.as.server.controller.descriptions.DeploymentDescription;
import org.jboss.dmr.ModelNode;

public class DeploymentRemoveHandler
implements ModelRemoveOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    public static final DeploymentRemoveHandler INSTANCE = new DeploymentRemoveHandler();

    private DeploymentRemoveHandler() {
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getRemoveDeploymentOperation((Locale)locale);
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode model = context.getSubModel();
        ModelNode compensatingOp = DeploymentAddHandler.getOperation(operation.get("address"), model);
        if (model.hasDefined("enabled") && model.get("enabled").asBoolean()) {
            String msg = String.format("Deployment %s must be undeployed before being removed", model.get("name").asString());
            throw new OperationFailedException(new ModelNode().set(msg));
        }
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }
}

