/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.server.controller.descriptions.DeploymentDescription;
import org.jboss.dmr.ModelNode;

public class ServerGroupDeploymentReplaceHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "replace-deployment";
    private final FileRepository fileRepository;
    private final ParametersValidator validator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address) {
        return Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
    }

    public ServerGroupDeploymentReplaceHandler(FileRepository fileRepository) {
        if (fileRepository == null) {
            throw new IllegalArgumentException("fileRepository is null");
        }
        this.fileRepository = fileRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.validator.registerValidator("to-replace", (ParameterValidator)new StringLengthValidator(1));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getDeployDeploymentOperation((Locale)locale);
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode replaceNode;
        ModelNode deployment;
        this.validator.validate(operation);
        String name = operation.require("name").asString();
        String toReplace = operation.require("to-replace").asString();
        if (name.equals(toReplace)) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(String.format("Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.", OPERATION_NAME, "name", "to-replace", "redeploy", "full-replace-deployment"));
        }
        try {
            deployment = context.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)}));
        }
        catch (IllegalArgumentException iae) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(String.format("No deployment with name %s found", name));
        }
        byte[] hash = deployment.require("hash").asBytes();
        this.fileRepository.getDeploymentFiles(hash);
        ModelNode deployments = context.getSubModel().get("deployment");
        ModelNode deployNode = deployments.hasDefined(name) ? deployments.get(name) : null;
        ModelNode modelNode = replaceNode = deployments.hasDefined(toReplace) ? deployments.get(toReplace) : null;
        if (deployNode == null) {
            deployNode = deployment.clone();
            deployments.get(name).set(deployNode);
        } else {
            if (deployNode.get("enabled").asBoolean()) {
                throw ServerGroupDeploymentReplaceHandler.operationFailed(String.format("Deployment %s is already started", toReplace));
            }
            if (replaceNode == null) {
                throw ServerGroupDeploymentReplaceHandler.operationFailed(String.format("No deployment with name %s found", toReplace));
            }
        }
        deployNode.get("enabled").set(true);
        replaceNode.get("enabled").set(false);
        ModelNode compensatingOp = operation.clone();
        compensatingOp.get("name").set(toReplace);
        compensatingOp.get("to-replace").set(name);
        resultHandler.handleResultComplete();
        return new BasicOperationResult();
    }

    private static OperationFailedException operationFailed(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }
}

