/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.domain.controller.DomainControllerSlaveClient;
import org.jboss.as.domain.controller.DomainModelImpl;
import org.jboss.dmr.ModelNode;

public class ReadResourceHandler
extends GlobalOperationHandlers.ReadResourceHandler {
    private final DomainModelImpl domainModelImpl;

    public ReadResourceHandler(DomainModelImpl domainModelImpl) {
        this.domainModelImpl = domainModelImpl;
    }

    protected void addProxyNodes(OperationContext context, PathAddress address, ModelNode originalOperation, ModelNode result, ModelNodeRegistration registry) {
        super.addProxyNodes(context, address, originalOperation, result, registry);
        try {
            if (address.size() == 0 && this.domainModelImpl.isMaster()) {
                for (Map.Entry<String, DomainControllerSlaveClient> entry : this.domainModelImpl.getRemoteHosts().entrySet()) {
                    ModelNode operation = originalOperation.clone();
                    PathAddress hostAddr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)entry.getKey())});
                    operation.get("address").set(hostAddr.toModelNode());
                    ModelNode hostResult = entry.getValue().execute(OperationBuilder.Factory.copy((OperationAttachments)context, (ModelNode)operation).build());
                    this.addProxyResultToMainResult(hostAddr, result, hostResult);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addProxyResultToMainResult(PathAddress address, ModelNode mainResult, ModelNode proxyResult) {
        PathAddress addr = !this.domainModelImpl.isMaster() && address.size() > 0 && address.getElement(0).getKey().equals("host") ? address.subAddress(1) : address;
        super.addProxyResultToMainResult(addr, mainResult, proxyResult);
    }
}

