/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ServerOperationResolver {
    private final String localHostName;

    ServerOperationResolver(String localHostName) {
        this.localHostName = localHostName;
    }

    Map<Set<ServerIdentity>, ModelNode> getServerOperations(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        if (address.size() == 0) {
            return this.resolveDomainRootOperation(operation, domain, host);
        }
        DomainKey domainKey = DomainKey.forName(address.getElement(0).getKey());
        switch (domainKey) {
            case EXTENSION: {
                Set<ServerIdentity> allServers = this.getAllRunningServers(host);
                return Collections.singletonMap(allServers, operation);
            }
            case DEPLOYMENT: {
                return Collections.emptyMap();
            }
            case PATH: {
                return this.getServerPathOperations(operation, address, host, true);
            }
            case PROFILE: {
                return this.getServerProfileOperations(operation, address, domain, host);
            }
            case INTERFACE: {
                return this.getServerInterfaceOperations(operation, address, host, true);
            }
            case SOCKET_BINDING_GROUP: {
                return this.getServerSocketBindingGroupOperations(operation, address, domain, host);
            }
            case SERVER_GROUP: {
                return this.getServerGroupOperations(operation, address, domain, host);
            }
            case HOST: {
                return this.getServerHostOperations(operation, address, domain, host);
            }
        }
        throw new IllegalStateException(String.format("Unexpected initial path key %s", address.getElement(0).getKey()));
    }

    private Set<ServerIdentity> getAllRunningServers(ModelNode hostModel) {
        return this.getServersForGroup(null, hostModel);
    }

    private Set<ServerIdentity> getServersForGroup(String groupName, ModelNode hostModel) {
        Set<ServerIdentity> result;
        if (hostModel.hasDefined("server-config")) {
            result = new HashSet();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (groupName != null && !groupName.equals(serverGroupName) || server.hasDefined("auto-start") && !server.get("auto-start").asBoolean()) continue;
                ServerIdentity groupedServer = new ServerIdentity(this.localHostName, serverGroupName, prop.getName());
                result.add(groupedServer);
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    private Set<ServerIdentity> getServersForType(String type, String ref, ModelNode domainModel, ModelNode hostModel) {
        Set<String> groups = this.getGroupsForType(type, ref, domainModel);
        HashSet<ServerIdentity> allServers = new HashSet<ServerIdentity>();
        for (String group : groups) {
            allServers.addAll(this.getServersForGroup(group, hostModel));
        }
        return allServers;
    }

    private Set<String> getGroupsForType(String type, String ref, ModelNode domainModel) {
        Set<String> groups;
        if (domainModel.hasDefined("server-group")) {
            groups = new HashSet();
            for (Property prop : domainModel.get("server-group").asPropertyList()) {
                ModelNode serverGroup = prop.getValue();
                if (!ref.equals(serverGroup.get(type).asString())) continue;
                groups.add(prop.getName());
            }
        } else {
            groups = Collections.emptySet();
        }
        return groups;
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerProfileOperations(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        if (address.size() == 1) {
            return Collections.emptyMap();
        }
        String profileName = address.getElement(0).getValue();
        Set<String> relatedProfiles = this.getRelatedElements("profile", profileName, domain);
        HashSet<ServerIdentity> allServers = new HashSet<ServerIdentity>();
        for (String profile : relatedProfiles) {
            allServers.addAll(this.getServersForType("profile", profile, domain, host));
        }
        ModelNode serverOp = operation.clone();
        PathAddress serverAddress = address.subAddress(1);
        serverOp.get("address").set(serverAddress.toModelNode());
        return Collections.singletonMap(allServers, serverOp);
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerInterfaceOperations(ModelNode operation, PathAddress address, ModelNode hostModel, boolean forDomain) {
        Map<Set<ServerIdentity>, ModelNode> result;
        String pathName = address.getElement(0).getValue();
        if (forDomain && hostModel.hasDefined("interface") && hostModel.get("interface").keys().contains(pathName)) {
            result = Collections.emptyMap();
        } else if ("add".equals(operation.get("operation").asString()) && !operation.has("criteria")) {
            result = Collections.emptyMap();
        } else if (hostModel.hasDefined("server-config")) {
            HashSet<ServerIdentity> servers = new HashSet<ServerIdentity>();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (server.hasDefined("interface") && server.get("interface").keys().contains(pathName) || server.hasDefined("auto-start") && !server.get("auto-start").asBoolean()) continue;
                ServerIdentity groupedServer = new ServerIdentity(this.localHostName, serverGroupName, prop.getName());
                servers.add(groupedServer);
            }
            ModelNode serverOp = operation.clone();
            serverOp.get("address").setEmptyList().add("interface", pathName);
            result = Collections.singletonMap(servers, serverOp);
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerPathOperations(ModelNode operation, PathAddress address, ModelNode hostModel, boolean forDomain) {
        Map<Set<ServerIdentity>, ModelNode> result;
        String pathName = address.getElement(0).getValue();
        if (forDomain && hostModel.hasDefined("path") && hostModel.get("path").keys().contains(pathName)) {
            result = Collections.emptyMap();
        } else if ("add".equals(operation.get("operation").asString()) && !operation.hasDefined("path")) {
            result = Collections.emptyMap();
        } else if (hostModel.hasDefined("server-config")) {
            HashSet<ServerIdentity> servers = new HashSet<ServerIdentity>();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (server.hasDefined("path") && server.get("path").keys().contains(pathName) || server.hasDefined("auto-start") && !server.get("auto-start").asBoolean()) continue;
                ServerIdentity groupedServer = new ServerIdentity(this.localHostName, serverGroupName, prop.getName());
                servers.add(groupedServer);
            }
            ModelNode serverOp = operation.clone();
            serverOp.get("address").setEmptyList().add("path", pathName);
            result = Collections.singletonMap(servers, serverOp);
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerSocketBindingGroupOperations(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        String bindingGroupName = address.getElement(0).getValue();
        Set<String> relatedBindingGroups = this.getRelatedElements("socket-binding-group", bindingGroupName, domain);
        HashSet<ServerIdentity> result = new HashSet<ServerIdentity>();
        for (String bindingGroup : relatedBindingGroups) {
            result.addAll(this.getServersForType("socket-binding-group", bindingGroup, domain, host));
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            ServerIdentity gs = (ServerIdentity)iter.next();
            ModelNode server = host.get(new String[]{"server-config", gs.getServerName()});
            if (!server.hasDefined("socket-binding-group") || bindingGroupName.equals(server.get("socket-binding-group").asString())) continue;
            iter.remove();
        }
        ModelNode serverOp = operation.clone();
        return Collections.singletonMap(result, serverOp);
    }

    private Set<String> getRelatedElements(String containerType, String parent, ModelNode domainModel) {
        HashSet<String> result = new HashSet<String>();
        result.add(parent);
        HashSet<String> checked = new HashSet<String>();
        checked.add(parent);
        ModelNode targetContainer = domainModel.get(new String[]{containerType, parent});
        if (targetContainer.hasDefined("includes")) {
            for (ModelNode include : targetContainer.get("includes").asList()) {
                checked.add(include.asString());
            }
        }
        List allContainers = domainModel.get(containerType).asPropertyList();
        while (checked.size() < allContainers.size()) {
            for (Property prop : allContainers) {
                String name = prop.getName();
                if (checked.contains(name)) continue;
                ModelNode container = prop.getValue();
                if (!container.hasDefined("includes")) {
                    checked.add(name);
                    continue;
                }
                boolean allKnown = true;
                for (ModelNode include : container.get("includes").asList()) {
                    String includeName = include.asString();
                    if (result.contains(includeName)) {
                        result.add(includeName);
                        break;
                    }
                    if (checked.contains(includeName)) continue;
                    allKnown = false;
                    break;
                }
                if (!allKnown) continue;
                checked.add(name);
            }
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerGroupOperations(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        String opName;
        ModelNode serverOp;
        Set<ServerIdentity> servers;
        Map<Set<ServerIdentity>, Object> result = null;
        if (address.size() > 1) {
            String type = address.getElement(1).getKey();
            if ("jvm".equals(type)) {
                result = Collections.emptyMap();
            } else if ("deployment".equals(type)) {
                String groupName = address.getElement(0).getValue();
                servers = this.getServersForGroup(groupName, host);
                serverOp = operation.clone();
                if ("add".equals(serverOp.get("operation").asString())) {
                    ModelNode domainDeployment = domain.get(new String[]{"deployment", address.getElement(1).getValue()});
                    serverOp.get("runtime-name").set(domainDeployment.get("runtime-name"));
                    serverOp.get("hash").set(domainDeployment.get("hash"));
                }
                PathAddress serverAddress = address.subAddress(1);
                serverOp.get("address").set(serverAddress.toModelNode());
                result = Collections.singletonMap(servers, serverOp);
            }
        }
        if (result == null && ("add-system-property".equals(opName = operation.require("operation").asString()) || "remove-system-property".equals(opName))) {
            String propName = operation.require("name").asString();
            servers = null;
            if (!this.hasSystemProperty(host, propName) && host.hasDefined("server-config")) {
                servers = new HashSet<ServerIdentity>();
                String groupName = address.getElement(0).getValue();
                for (Property serverProp : host.get("server-config").asPropertyList()) {
                    ModelNode server = serverProp.getValue();
                    if (!groupName.equals(server.require("group").asString()) || this.hasSystemProperty(server, propName) || server.hasDefined("auto-start") && !server.get("auto-start").asBoolean()) continue;
                    servers.add(new ServerIdentity(this.localHostName, groupName, serverProp.getName()));
                }
            }
            if (servers != null && servers.size() > 0) {
                serverOp = operation.clone();
                serverOp.get("address").setEmptyList();
                result = Collections.singletonMap(servers, serverOp);
            }
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> resolveDomainRootOperation(ModelNode operation, ModelNode domain, ModelNode host) {
        Map<Set<ServerIdentity>, ModelNode> result = null;
        String opName = operation.require("operation").asString();
        if ("add-system-property".equals(opName) || "remove-system-property".equals(opName)) {
            String propName = operation.require("name").asString();
            HashSet<ServerIdentity> servers = null;
            if (!this.hasSystemProperty(host, propName) && host.hasDefined("server-config")) {
                servers = new HashSet<ServerIdentity>();
                for (Property serverProp : host.get("server-config").asPropertyList()) {
                    String groupName;
                    ModelNode serverGroup;
                    ModelNode server = serverProp.getValue();
                    if (this.hasSystemProperty(server, propName) || server.hasDefined("auto-start") && !server.get("auto-start").asBoolean() || this.hasSystemProperty(serverGroup = domain.get(new String[]{"group", groupName = server.require("group").asString()}), propName)) continue;
                    servers.add(new ServerIdentity(this.localHostName, groupName, serverProp.getName()));
                }
            }
            if (servers != null && servers.size() > 0) {
                ModelNode serverOp = operation.clone();
                serverOp.get("address").setEmptyList();
                result = Collections.singletonMap(servers, serverOp);
            }
        } else if ("full-replace-deployment".equals(opName)) {
            String propName = operation.require("name").asString();
            Set<String> groups = this.getServerGroupsForDeployment(propName, domain);
            HashSet<ServerIdentity> allServers = new HashSet<ServerIdentity>();
            for (String group : groups) {
                allServers.addAll(this.getServersForGroup(group, host));
            }
            return Collections.singletonMap(allServers, operation);
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Set<String> getServerGroupsForDeployment(String deploymentName, ModelNode domainModel) {
        Set<String> groups;
        if (domainModel.hasDefined("server-group")) {
            groups = new HashSet();
            for (Property prop : domainModel.get("server-group").asPropertyList()) {
                ModelNode serverGroup = prop.getValue();
                if (!serverGroup.hasDefined("deployment") || !serverGroup.get("deployment").hasDefined(deploymentName)) continue;
                groups.add(prop.getName());
            }
        } else {
            groups = Collections.emptySet();
        }
        return groups;
    }

    private boolean hasSystemProperty(ModelNode resource, String propName) {
        boolean result = false;
        if (resource.hasDefined("system-properties")) {
            for (Property prop : resource.get("system-properties").asPropertyList()) {
                if (!propName.equals(prop.getName())) continue;
                return true;
            }
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerHostOperations(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        if (address.size() == 1) {
            return this.resolveHostRootOperation(operation, host);
        }
        HostKey hostKey = HostKey.forName(address.getElement(1).getKey());
        address = address.subAddress(1);
        switch (hostKey) {
            case PATH: {
                return this.getServerPathOperations(operation, address, host, false);
            }
            case MANAGEMENT: {
                return Collections.emptyMap();
            }
            case INTERFACE: {
                return this.getServerInterfaceOperations(operation, address, host, false);
            }
            case JVM: {
                return Collections.emptyMap();
            }
            case SERVER_CONFIG: {
                return this.resolveServerConfigOperation(operation, address, host);
            }
        }
        throw new IllegalStateException(String.format("Unexpected initial path key %s", address.getElement(0).getKey()));
    }

    private Map<Set<ServerIdentity>, ModelNode> resolveHostRootOperation(ModelNode operation, ModelNode host) {
        Map<Set<ServerIdentity>, ModelNode> result = null;
        String opName = operation.require("operation").asString();
        if ("write-attribute".equals(opName)) {
            result = Collections.emptyMap();
        } else if ("add-system-property".equals(opName) || "remove-system-property".equals(opName)) {
            String propName = operation.require("name").asString();
            HashSet<ServerIdentity> servers = null;
            if (host.hasDefined("server-config")) {
                servers = new HashSet<ServerIdentity>();
                for (Property serverProp : host.get("server-config").asPropertyList()) {
                    ModelNode server = serverProp.getValue();
                    if (this.hasSystemProperty(server, propName) || server.hasDefined("auto-start") && !server.get("auto-start").asBoolean()) continue;
                    String groupName = server.require("group").asString();
                    servers.add(new ServerIdentity(this.localHostName, groupName, serverProp.getName()));
                }
            }
            if (servers != null && servers.size() > 0) {
                ModelNode serverOp = operation.clone();
                serverOp.get("address").setEmptyList();
                result = Collections.singletonMap(servers, serverOp);
            }
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> resolveServerConfigOperation(ModelNode operation, PathAddress address, ModelNode host) {
        Map<Set<ServerIdentity>, ModelNode> result;
        ModelNode serverOp = null;
        if (address.size() > 2) {
            String type = address.getElement(2).getKey();
            if ("path".equals(type) || "interface".equals(type)) {
                serverOp = operation.clone();
                PathAddress serverAddress = address.subAddress(2);
                serverOp.get("address").set(serverAddress.toModelNode());
            }
        } else {
            String opName = operation.require("operation").asString();
            if ("add-system-property".equals(opName) || "remove-system-property".equals(opName)) {
                serverOp = operation.clone();
                serverOp.get("address").setEmptyList();
            }
        }
        if (serverOp == null) {
            result = Collections.emptyMap();
        } else {
            String serverName = address.getElement(0).getValue();
            ModelNode serverNode = host.get(new String[]{"server-config", serverName});
            ServerIdentity gs = new ServerIdentity(this.localHostName, serverNode.require("group").asString(), serverName);
            Set<ServerIdentity> set = Collections.singleton(gs);
            result = Collections.singletonMap(set, serverOp);
        }
        return result;
    }

    private static enum HostKey {
        UNKNOWN(null),
        PATH("path"),
        MANAGEMENT("management"),
        INTERFACE("interface"),
        JVM("jvm"),
        SERVER("server"),
        SERVER_CONFIG("server-config");

        private final String name;
        private static final Map<String, HostKey> MAP;

        private HostKey(String name) {
            this.name = name;
        }

        public static HostKey forName(String localName) {
            HostKey element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, HostKey> map = new HashMap<String, HostKey>();
            for (HostKey element : HostKey.values()) {
                String name = element.name;
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    private static enum DomainKey {
        UNKNOWN(null),
        EXTENSION("extension"),
        PATH("path"),
        PROFILE("profile"),
        INTERFACE("interface"),
        SOCKET_BINDING_GROUP("socket-binding-group"),
        DEPLOYMENT("deployment"),
        SERVER_GROUP("server-group"),
        HOST("host");

        private final String name;
        private static final Map<String, DomainKey> MAP;

        private DomainKey(String name) {
            this.name = name;
        }

        public static DomainKey forName(String localName) {
            DomainKey element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, DomainKey> map = new HashMap<String, DomainKey>();
            for (DomainKey element : DomainKey.values()) {
                String name = element.name;
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

