/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.dmr.ModelNode;

public class OperationRouting {
    private final Set<String> hosts = new HashSet<String>();
    private final boolean twoStep;
    private final boolean routeToMaster;

    public static OperationRouting determineRouting(ModelNode operation, LocalHostControllerInfo localHostControllerInfo, ImmutableManagementResourceRegistration registry) throws OperationFailedException {
        Set flags;
        PathElement first;
        OperationRouting.checkNull(operation, registry);
        OperationRouting routing = null;
        String targetHost = null;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String operationName = operation.get("operation").asString();
        if (address.size() > 0 && "host".equals((first = address.getElement(0)).getKey())) {
            targetHost = first.getValue();
        }
        if (targetHost != null) {
            PathElement first2;
            flags = registry.getOperationFlags(PathAddress.EMPTY_ADDRESS, operation.require("operation").asString());
            OperationRouting.checkNull(operation, flags);
            if (flags.contains(OperationEntry.Flag.READ_ONLY)) {
                routing = new OperationRouting(targetHost, false);
            } else if (address.size() > 1 && "server".equals((first2 = address.getElement(1)).getKey())) {
                routing = new OperationRouting(targetHost, false);
            }
            if (routing == null) {
                routing = "start".equals(operationName) || "stop".equals(operationName) || "restart".equals(operationName) ? new OperationRouting(targetHost, false) : new OperationRouting(targetHost, true);
            }
        } else {
            flags = registry.getOperationFlags(PathAddress.EMPTY_ADDRESS, operation.require("operation").asString());
            OperationRouting.checkNull(operation, flags);
            if (flags.contains(OperationEntry.Flag.READ_ONLY)) {
                routing = new OperationRouting(localHostControllerInfo.getLocalHostName(), false);
            } else if (!localHostControllerInfo.isMasterDomainController()) {
                routing = new OperationRouting();
            } else if (flags.contains(OperationEntry.Flag.DEPLOYMENT_UPLOAD)) {
                routing = new OperationRouting(localHostControllerInfo.getLocalHostName(), false);
            }
        }
        if (routing == null) {
            if ("composite".equals(operationName)) {
                if (operation.hasDefined("steps")) {
                    HashSet<String> allHosts = new HashSet<String>();
                    boolean twoStep = false;
                    for (ModelNode step : operation.get("steps").asList()) {
                        ImmutableManagementResourceRegistration stepRegistry;
                        OperationRouting stepRouting = OperationRouting.determineRouting(step, localHostControllerInfo, stepRegistry = registry.getSubModel(PathAddress.pathAddress((ModelNode)step.get("address"))));
                        if (stepRouting.isTwoStep()) {
                            twoStep = true;
                        }
                        allHosts.addAll(stepRouting.getHosts());
                    }
                    routing = allHosts.size() == 1 ? new OperationRouting((String)allHosts.iterator().next(), twoStep) : new OperationRouting(allHosts);
                } else {
                    routing = new OperationRouting(localHostControllerInfo.getLocalHostName(), false);
                }
            } else {
                routing = new OperationRouting(true);
            }
        }
        return routing;
    }

    private static void checkNull(ModelNode operation, Object toCheck) throws OperationFailedException {
        if (toCheck == null) {
            String msg = String.format("No handler for %s at address %s", operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.get("address")));
            throw new OperationFailedException(new ModelNode().set(msg));
        }
    }

    private OperationRouting() {
        this.twoStep = false;
        this.routeToMaster = true;
    }

    private OperationRouting(boolean twoStep) {
        this.twoStep = twoStep;
        this.routeToMaster = !twoStep;
    }

    public OperationRouting(String host, boolean twoStep) {
        this.hosts.add(host);
        this.twoStep = twoStep;
        this.routeToMaster = false;
    }

    public OperationRouting(Collection<String> hosts) {
        this.hosts.addAll(hosts);
        this.twoStep = true;
        this.routeToMaster = false;
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public String getSingleHost() {
        return this.hosts.size() == 1 ? this.hosts.iterator().next() : null;
    }

    public boolean isTwoStep() {
        return this.twoStep;
    }

    public boolean isRouteToMaster() {
        return this.routeToMaster;
    }

    public boolean isLocalOnly(String localHostName) {
        return localHostName.equals(this.getSingleHost());
    }

    public boolean isLocalCallNeeded(String localHostName) {
        return this.isLocalOnly(localHostName) || this.hosts.size() == 0 || this.hosts.contains(localHostName);
    }
}

