/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.coordination.OperationCoordinatorStepHandler;
import org.jboss.as.domain.controller.operations.coordination.OperationSlaveStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class PrepareStepHandler
implements OperationStepHandler {
    public static final String EXECUTE_FOR_COORDINATOR = "execute-for-coordinator";
    static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    private static boolean trace = false;
    private final LocalHostControllerInfo localHostControllerInfo;
    private final OperationCoordinatorStepHandler coordinatorHandler;
    private final OperationSlaveStepHandler slaveHandler;

    public static boolean isTraceEnabled() {
        return trace;
    }

    public PrepareStepHandler(LocalHostControllerInfo localHostControllerInfo, Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.slaveHandler = new OperationSlaveStepHandler(localHostControllerInfo);
        this.coordinatorHandler = new OperationCoordinatorStepHandler(localHostControllerInfo, hostProxies, serverProxies, this.slaveHandler);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        trace = log.isTraceEnabled();
        if (context.isBooting()) {
            this.executeDirect(context, operation);
        } else if (operation.hasDefined("operation-headers") && operation.get("operation-headers").hasDefined(EXECUTE_FOR_COORDINATOR) && operation.get("operation-headers").get(EXECUTE_FOR_COORDINATOR).asBoolean()) {
            this.slaveHandler.execute(context, operation);
        } else if (this.isServerOperation(operation)) {
            this.executeDirect(context, operation);
        } else {
            this.coordinatorHandler.execute(context, operation);
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.coordinatorHandler.setExecutorService(executorService);
    }

    private boolean isServerOperation(ModelNode operation) {
        PathAddress addr = PathAddress.pathAddress((ModelNode)operation.get("address"));
        return addr.size() > 1 && "host".equals(addr.getElement(0).getKey()) && this.localHostControllerInfo.getLocalHostName().equals(addr.getElement(0).getValue()) && "server".equals(addr.getElement(1).getKey());
    }

    private void executeDirect(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (trace) {
            log.trace((Object)(this.getClass().getSimpleName() + " executing direct"));
        }
        String operationName = operation.require("operation").asString();
        OperationStepHandler stepHandler = null;
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        if (registration != null) {
            stepHandler = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, operationName);
        }
        if (stepHandler != null) {
            context.addStep(stepHandler, OperationContext.Stage.MODEL);
        } else {
            context.getFailureDescription().set(String.format("No handler for operation %s at address %s", operationName, PathAddress.pathAddress((ModelNode)operation.get("address"))));
        }
        context.completeStep();
    }
}

