/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.as.domain.controller.operations.coordination.PrepareStepHandler;
import org.jboss.as.domain.controller.operations.coordination.ProxyTask;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class DomainSlaveHandler
implements OperationStepHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.controller");
    private final ExecutorService executorService;
    private final DomainOperationContext domainOperationContext;
    private final Map<String, ProxyController> hostProxies;

    public DomainSlaveHandler(Map<String, ProxyController> hostProxies, DomainOperationContext domainOperationContext, ExecutorService executorService) {
        this.hostProxies = hostProxies;
        this.domainOperationContext = domainOperationContext;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.hasFailureDescription()) {
            context.setRollbackOnly();
            context.completeStep();
            return;
        }
        HashMap<String, ProxyTask> tasks = new HashMap<String, ProxyTask>();
        HashMap<String, Future<ModelNode>> futures = new HashMap<String, Future<ModelNode>>();
        for (Map.Entry<String, ProxyController> entry : this.hostProxies.entrySet()) {
            String host = entry.getKey();
            ProxyTask task = new ProxyTask(host, operation.clone(), context, entry.getValue());
            tasks.put(host, task);
            futures.put(host, this.executorService.submit(task));
        }
        boolean interrupted = false;
        try {
            for (Map.Entry entry : tasks.entrySet()) {
                ProxyTask task2 = (ProxyTask)entry.getValue();
                ModelNode result = null;
                try {
                    result = ((ProxyTask)entry.getValue()).getUncommittedResult();
                }
                catch (InterruptedException e) {
                    result = new ModelNode();
                    result.get("outcome").set("failed");
                    result.get("failure-description").set(String.format("Interrupted waiting for result from host %s", entry.getKey()));
                    interrupted = true;
                    task2.cancel();
                    ((Future)futures.get(entry.getKey())).cancel(true);
                }
                if (PrepareStepHandler.isTraceEnabled()) {
                    PrepareStepHandler.log.trace((Object)("Result for remote host " + (String)entry.getKey() + " is " + result));
                }
                this.domainOperationContext.addHostControllerResult((String)entry.getKey(), result);
            }
            context.completeStep();
        }
        catch (Throwable throwable) {
            try {
                boolean rollback = this.domainOperationContext.isCompleteRollback();
                for (ProxyTask task3 : tasks.values()) {
                    task3.finalizeTransaction(!rollback);
                }
                int timeout = 10;
                for (Map.Entry entry : futures.entrySet()) {
                    Future future = (Future)entry.getValue();
                    try {
                        ModelNode finalResult = future.isCancelled() ? this.getCancelledResult() : (ModelNode)future.get();
                        this.domainOperationContext.addHostControllerResult((String)entry.getKey(), finalResult);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        log.warnf("Interrupted awaiting final response from host %s", entry.getKey());
                    }
                    catch (ExecutionException e) {
                        log.warnf(e.getCause(), "Caught exception awaiting final response from host %s", entry.getKey());
                    }
                }
                throw throwable;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        try {
            boolean rollback = this.domainOperationContext.isCompleteRollback();
            for (ProxyTask task : tasks.values()) {
                task.finalizeTransaction(!rollback);
            }
            int timeout = 10;
            for (Map.Entry entry : futures.entrySet()) {
                Future future = (Future)entry.getValue();
                try {
                    ModelNode finalResult = future.isCancelled() ? this.getCancelledResult() : (ModelNode)future.get();
                    this.domainOperationContext.addHostControllerResult((String)entry.getKey(), finalResult);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    log.warnf("Interrupted awaiting final response from host %s", entry.getKey());
                }
                catch (ExecutionException e) {
                    log.warnf(e.getCause(), "Caught exception awaiting final response from host %s", entry.getKey());
                }
            }
            return;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ModelNode getCancelledResult() {
        ModelNode cancelled = new ModelNode();
        cancelled.get("outcome").set("cancelled");
        return cancelled;
    }
}

