/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.ParsedOp;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationsResolverHandler;
import org.jboss.dmr.ModelNode;

public class OperationSlaveStepHandler {
    private final LocalHostControllerInfo localHostControllerInfo;
    private final Map<String, ProxyController> serverProxies;

    OperationSlaveStepHandler(LocalHostControllerInfo localHostControllerInfo, Map<String, ProxyController> serverProxies) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.serverProxies = serverProxies;
    }

    void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        operation.get("operation-headers").remove("execute-for-coordinator");
        ModelNode response = new ModelNode();
        this.addSteps(context, operation, response, true);
        context.completeStep();
    }

    void addSteps(OperationContext context, ModelNode operation, ModelNode response, boolean recordResponse) throws OperationFailedException {
        PathAddress originalAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ImmutableManagementResourceRegistration originalRegistration = context.getResourceRegistration();
        if (originalRegistration == null) {
            String operationName = operation.require("operation").asString();
            throw new OperationFailedException(new ModelNode().set(String.format("No handler for operation %s at address %s", operationName, originalAddress)));
        }
        Resource root = context.getRootResource();
        ModelNode model = Resource.Tools.readModel((Resource)root);
        ParsedOp parsedOp = this.parseOperation(operation, 0, model);
        ModelNode domainOp = parsedOp.getDomainOperation();
        if (domainOp.isDefined()) {
            this.addBasicStep(context, domainOp);
        } else {
            response.get("result").set("ignored-by-unaffected-host-controller");
        }
        ServerOperationResolver resolver = new ServerOperationResolver(this.localHostControllerInfo.getLocalHostName(), this.serverProxies);
        ServerOperationsResolverHandler sorh = new ServerOperationsResolverHandler(this.localHostControllerInfo.getLocalHostName(), resolver, parsedOp, originalAddress, originalRegistration, response, recordResponse);
        context.addStep((OperationStepHandler)sorh, OperationContext.Stage.DOMAIN);
    }

    private void addBasicStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        OperationStepHandler stepHandler = context.getResourceRegistration().getOperationHandler(PathAddress.EMPTY_ADDRESS, operationName);
        if (stepHandler == null) {
            throw new OperationFailedException(new ModelNode().set(String.format("No handler for operation %s at address %s", operationName, PathAddress.pathAddress((ModelNode)operation.get("address")))));
        }
        context.addStep(operation, stepHandler, OperationContext.Stage.MODEL);
    }

    private String getLocalHostName() {
        return this.localHostControllerInfo.getLocalHostName();
    }

    private ParsedOp parseOperation(ModelNode operation, int index, ModelNode domainModel) {
        PathElement first;
        String targetHost = null;
        String runningServerTarget = null;
        ModelNode runningServerOp = null;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        if (address.size() > 0 && "host".equals((first = address.getElement(0)).getKey())) {
            targetHost = first.getValue();
            if (address.size() > 1 && "server".equals(address.getElement(1).getKey())) {
                runningServerTarget = address.getElement(1).getValue();
                ModelNode relativeAddress = new ModelNode();
                for (int i = 2; i < address.size(); ++i) {
                    PathElement element = address.getElement(i);
                    relativeAddress.add(element.getKey(), element.getValue());
                }
                runningServerOp = operation.clone();
                runningServerOp.get("address").set(relativeAddress);
            }
        }
        ParsedOp result = null;
        if (targetHost != null && !this.getLocalHostName().equals(targetHost)) {
            result = new SimpleParsedOp(index);
        } else if (runningServerTarget != null) {
            result = new SimpleParsedOp(index, runningServerTarget, runningServerOp, domainModel);
        } else if ("composite".equals(operation.require("operation").asString())) {
            if (operation.hasDefined("steps")) {
                int stepNum = 0;
                ArrayList<ParsedOp> parsedSteps = new ArrayList<ParsedOp>();
                for (ModelNode step : operation.get("steps").asList()) {
                    parsedSteps.add(this.parseOperation(step, stepNum++, domainModel));
                }
                result = new ParsedMultiStepOp(index, parsedSteps);
            } else {
                result = new SimpleParsedOp(index, operation, address);
            }
        } else {
            result = new SimpleParsedOp(index, operation, address);
        }
        return result;
    }

    private class ParsedMultiStepOp
    implements ParsedOp {
        private final List<ParsedOp> steps;

        private ParsedMultiStepOp(int index, List<ParsedOp> steps) {
            this.steps = steps;
        }

        @Override
        public Map<Set<ServerIdentity>, ModelNode> getServerOps(ParsedOp.ServerOperationProvider provider) {
            HashMap<Set, List> buildingBlocks = new HashMap<Set, List>();
            for (ParsedOp step : this.steps) {
                Map<Set<ServerIdentity>, ModelNode> stepResult = step.getServerOps(provider);
                if (stepResult.size() == 0) continue;
                if (buildingBlocks.size() == 0) {
                    for (Map.Entry<Set<ServerIdentity>, ModelNode> entry : stepResult.entrySet()) {
                        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
                        list.add(entry.getValue());
                        buildingBlocks.put(entry.getKey(), list);
                    }
                    continue;
                }
                for (Map.Entry<Set<ServerIdentity>, ModelNode> entry : stepResult.entrySet()) {
                    List existingOp = (List)buildingBlocks.get(entry.getKey());
                    if (existingOp != null) {
                        existingOp.add(entry.getValue());
                        continue;
                    }
                    HashSet newSet = new HashSet(entry.getKey());
                    HashSet existingSets = new HashSet(buildingBlocks.keySet());
                    for (Set existing : existingSets) {
                        HashSet copy = new HashSet(existing);
                        copy.retainAll(newSet);
                        if (copy.size() <= 0) continue;
                        if (copy.size() == existing.size()) {
                            ((List)buildingBlocks.get(existing)).add(entry.getValue());
                        } else {
                            List existingSteps = (List)buildingBlocks.remove(existing);
                            ArrayList newSteps = new ArrayList(existingSteps);
                            buildingBlocks.put(copy, newSteps);
                            existing.removeAll(copy);
                            buildingBlocks.put(existing, existingSteps);
                        }
                        newSet.removeAll(copy);
                    }
                    if (newSet.size() <= 0) continue;
                    ArrayList<ModelNode> toAdd = new ArrayList<ModelNode>();
                    toAdd.add(entry.getValue());
                    buildingBlocks.put(newSet, toAdd);
                }
            }
            Map<Set<ServerIdentity>, ModelNode> result = null;
            if (buildingBlocks.size() > 0) {
                result = new HashMap();
                for (Map.Entry entry : buildingBlocks.entrySet()) {
                    List ops = (List)entry.getValue();
                    if (ops.size() == 1) {
                        result.put((Set<ServerIdentity>)entry.getKey(), (ModelNode)ops.get(0));
                        continue;
                    }
                    ModelNode composite = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
                    ModelNode steps = composite.get("steps");
                    for (ModelNode step : (List)entry.getValue()) {
                        steps.add(step);
                    }
                    result.put((Set<ServerIdentity>)entry.getKey(), composite);
                }
            } else {
                result = Collections.emptyMap();
            }
            return result;
        }

        @Override
        public ModelNode getDomainOperation() {
            ModelNode result = null;
            ArrayList<ModelNode> domainSteps = new ArrayList<ModelNode>();
            for (ParsedOp step : this.steps) {
                ModelNode stepNode = step.getDomainOperation();
                if (stepNode == null) continue;
                domainSteps.add(stepNode);
            }
            ModelNode stepsParam = new ModelNode();
            for (ModelNode stepNode : domainSteps) {
                stepsParam.add(stepNode);
            }
            result = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
            result.get("steps").set(stepsParam);
            return result;
        }

        @Override
        public ModelNode getFormattedDomainResult(ModelNode resultNode) {
            ModelNode formatted = new ModelNode();
            int resultStep = 0;
            for (int i = 0; i < this.steps.size(); ++i) {
                ParsedOp po = this.steps.get(i);
                if (po.getDomainOperation() != null) {
                    String label = "step-" + ++resultStep;
                    ModelNode stepResultNode = resultNode.get(label);
                    ModelNode formattedStepResultNode = po.getFormattedDomainResult(stepResultNode);
                    formatted.get("step-" + (i + 1)).set(formattedStepResultNode);
                    continue;
                }
                formatted.get(new String[]{"step-" + (i + 1), "outcome"}).set("ignored-by-unaffected-host-controller");
            }
            return formatted;
        }
    }

    private class SimpleParsedOp
    implements ParsedOp {
        private final String domainStep;
        private final ModelNode domainOp;
        private final PathAddress domainOpAddress;
        private Map<Set<ServerIdentity>, ModelNode> serverOps;

        private SimpleParsedOp(int index) {
            this.domainStep = "step-" + (index + 1);
            this.domainOp = null;
            this.domainOpAddress = null;
            this.serverOps = Collections.emptyMap();
        }

        private SimpleParsedOp(int index, ModelNode domainOp, PathAddress domainOpAddress) {
            this.domainStep = "step-" + (index + 1);
            this.domainOp = domainOp;
            this.domainOpAddress = domainOpAddress;
            this.serverOps = null;
        }

        private SimpleParsedOp(int index, String serverName, ModelNode serverOp, ModelNode domainModel) {
            this.domainStep = "step-" + (index + 1);
            this.domainOp = null;
            this.domainOpAddress = null;
            ServerIdentity serverIdentity = new ServerIdentity(OperationSlaveStepHandler.this.getLocalHostName(), this.getServerGroup(serverName, domainModel), serverName);
            this.serverOps = Collections.singletonMap(Collections.singleton(serverIdentity), serverOp);
        }

        @Override
        public ModelNode getDomainOperation() {
            return this.domainOp;
        }

        @Override
        public Map<Set<ServerIdentity>, ModelNode> getServerOps(ParsedOp.ServerOperationProvider provider) {
            Map<Set<ServerIdentity>, ModelNode> result = this.serverOps;
            if (this.serverOps == null) {
                result = provider.getServerOperations(this.domainOp, this.domainOpAddress);
            }
            return result;
        }

        @Override
        public ModelNode getFormattedDomainResult(ModelNode resultNode) {
            ModelNode formatted = new ModelNode();
            formatted.get(this.domainStep).set(resultNode);
            return formatted;
        }

        private String getServerGroup(String serverName, ModelNode domainModel) {
            return domainModel.require("host").require(OperationSlaveStepHandler.this.getLocalHostName()).require("server-config").require(serverName).require("group").asString();
        }
    }
}

