/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import java.net.URI;
import org.jboss.com.sun.net.httpserver.Filter;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;

class TrailingSlashFilter
extends Filter {
    TrailingSlashFilter() {
    }

    public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
        URI requestURI = exchange.getRequestURI();
        String path = requestURI.getPath();
        if (!path.endsWith("/")) {
            Headers responseHeaders = exchange.getResponseHeaders();
            responseHeaders.add("Location", path + "/");
            exchange.sendResponseHeaders(301, 0L);
            exchange.close();
        } else {
            chain.doFilter(exchange);
        }
    }

    public String description() {
        return "Ensure all requests to the context have a trailing slash.";
    }
}

