/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.com.sun.net.httpserver.Authenticator;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpPrincipal;
import org.jboss.com.sun.net.httpserver.HttpsExchange;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class BasicAuthenticator
extends org.jboss.com.sun.net.httpserver.BasicAuthenticator {
    private final CallbackHandler callbackHandler;
    private final boolean verifyPasswordCallback;

    public BasicAuthenticator(DomainCallbackHandler callbackHandler, String realm) {
        super(realm);
        this.callbackHandler = callbackHandler;
        this.verifyPasswordCallback = BasicAuthenticator.contains(VerifyPasswordCallback.class, callbackHandler.getSupportedCallbacks());
    }

    public Authenticator.Result authenticate(HttpExchange httpExchange) {
        HttpsExchange httpsExch;
        SSLSession session;
        if (httpExchange instanceof HttpsExchange && (session = (httpsExch = (HttpsExchange)httpExchange).getSSLSession()) != null) {
            try {
                Principal p = session.getPeerPrincipal();
                return new Authenticator.Success(new HttpPrincipal(p.getName(), this.realm));
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
        return super.authenticate(httpExchange);
    }

    public boolean checkCredentials(String username, String password) {
        NameCallback ncb = new NameCallback("Username", username);
        Object passwordCallback = this.verifyPasswordCallback ? new VerifyPasswordCallback(password) : new PasswordCallback("Password", false);
        Callback[] callbacks = new Callback[]{ncb, passwordCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            HttpServerLogger.ROOT_LOGGER.debug("Callback handle failed.", e);
            return false;
        }
        catch (UnsupportedCallbackException e) {
            throw HttpServerMessages.MESSAGES.callbackRejected(e);
        }
        if (this.verifyPasswordCallback) {
            return passwordCallback.isVerified();
        }
        char[] expectedPassword = ((PasswordCallback)passwordCallback).getPassword();
        return Arrays.equals(password.toCharArray(), expectedPassword);
    }

    public static boolean requiredCallbacksSupported(Class[] callbacks) {
        if (!BasicAuthenticator.contains(NameCallback.class, callbacks)) {
            return false;
        }
        return BasicAuthenticator.contains(PasswordCallback.class, callbacks) || BasicAuthenticator.contains(VerifyPasswordCallback.class, callbacks);
    }

    private static boolean contains(Class clazz, Class[] classes) {
        for (Class current : classes) {
            if (!current.equals(clazz)) continue;
            return true;
        }
        return false;
    }
}

