/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.as.controller.security.SecurityContext;

class SecurityActions {
    SecurityActions() {
    }

    static boolean getBoolean(final String key) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(key);
            }
        });
    }

    static int getInt(final String key, final int def) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(key, def);
            }
        });
    }

    static void setSecurityContextSubject(final Subject subject) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext.setSubject((Subject)subject);
                return null;
            }
        });
    }

    static void clearSubjectSecurityContext() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext.clearSubject();
                return null;
            }
        });
    }
}

