/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.SecurityRealmAddHandler;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class SecurityRealmRemoveHandler
implements OperationStepHandler {
    public static final SecurityRealmRemoveHandler INSTANCE = new SecurityRealmRemoveHandler();

    private SecurityRealmRemoveHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final boolean reloadRequired = ManagementUtil.isSecurityRealmReloadRequired(context, operation);
                final String realmName = ManagementUtil.getSecurityRealmName(operation);
                if (reloadRequired) {
                    context.reloadRequired();
                } else {
                    SecurityRealmRemoveHandler.this.removeServices(context, realmName, model);
                }
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        if (reloadRequired) {
                            context.revertReloadRequired();
                        } else {
                            SecurityRealmRemoveHandler.this.recoverServices(context, realmName, model);
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void removeServices(OperationContext context, String realmName, ModelNode model) throws OperationFailedException {
        ServiceName realmServiceName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmName});
        context.removeService(realmServiceName);
        context.removeService(realmServiceName.append(new String[]{"secret"}));
        context.removeService(realmServiceName.append(new String[]{"ssl"}));
        context.removeService(realmServiceName.append(new String[]{"keystore"}));
        context.removeService(realmServiceName.append(new String[]{"truststore"}));
        context.removeService(realmServiceName.append(new String[]{"users"}));
        context.removeService(realmServiceName.append(new String[]{"properties"}));
        context.removeService(realmServiceName.append(new String[]{"ldap"}));
    }

    protected void recoverServices(OperationContext context, String realmName, ModelNode model) {
        try {
            SecurityRealmAddHandler.INSTANCE.installServices(context, realmName, model, null, null);
        }
        catch (OperationFailedException e) {
            throw ControllerMessages.MESSAGES.failedToRecoverServices(e);
        }
    }
}

