/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.sasl.callback.DigestHashCallback;

public class PropertiesCallbackHandler
implements Service<DomainCallbackHandler>,
DomainCallbackHandler {
    public static final String SERVICE_SUFFIX = "properties";
    private static final Class[] PLAIN_CALLBACKS = new Class[]{AuthorizeCallback.class, RealmCallback.class, NameCallback.class, PasswordCallback.class};
    private static final Class[] DIGEST_CALLBACKS = new Class[]{AuthorizeCallback.class, RealmCallback.class, NameCallback.class, DigestHashCallback.class};
    private static final String DOLLAR_LOCAL = "$local";
    private final Class[] supportedCallbacks;
    private final String realm;
    private final String path;
    private final boolean plainText;
    private final InjectedValue<String> relativeTo = new InjectedValue();
    private File propertiesFile;
    private volatile long fileUpdated = -1L;
    private volatile Properties userProperties = null;

    public PropertiesCallbackHandler(String realm, ModelNode properties) {
        this.realm = realm;
        this.path = properties.require("path").asString();
        this.plainText = properties.hasDefined("plain-text") ? properties.require("plain-text").asBoolean() : false;
        this.supportedCallbacks = this.plainText ? PLAIN_CALLBACKS : DIGEST_CALLBACKS;
    }

    public void start(StartContext context) throws StartException {
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        String file = relativeTo == null ? this.path : relativeTo + "/" + this.path;
        this.propertiesFile = new File(file);
        try {
            this.getUsersProperties();
        }
        catch (IOException ioe) {
            throw DomainManagementMessages.MESSAGES.unableToLoadProperties(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getUsersProperties() throws IOException {
        boolean loadRequired;
        boolean bl = loadRequired = this.userProperties == null || this.fileUpdated != this.propertiesFile.lastModified();
        if (loadRequired) {
            PropertiesCallbackHandler propertiesCallbackHandler = this;
            synchronized (propertiesCallbackHandler) {
                boolean loadReallyRequired;
                long fileLastModified = this.propertiesFile.lastModified();
                boolean bl2 = loadReallyRequired = this.userProperties == null || this.fileUpdated != fileLastModified;
                if (loadReallyRequired) {
                    DomainManagementLogger.ROOT_LOGGER.debugf("Reloading properties file '%s%", this.propertiesFile.getAbsolutePath());
                    Properties props = new Properties();
                    FileInputStream is = new FileInputStream(this.propertiesFile);
                    try {
                        props.load(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                    this.checkWeakPasswords(props);
                    this.userProperties = props;
                    this.fileUpdated = fileLastModified;
                }
            }
        }
        return this.userProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void persistProperties() throws IOException {
        Properties toSave = (Properties)this.userProperties.clone();
        File backup = new File(this.propertiesFile.getCanonicalPath() + ".bak");
        if (backup.exists() && !backup.delete()) {
            throw new IllegalStateException("Unable to delete backup properties file.");
        }
        if (!this.propertiesFile.renameTo(backup)) {
            throw new IllegalStateException("Unable to backup properties file.");
        }
        FileReader fr = new FileReader(backup);
        BufferedReader br = new BufferedReader(fr);
        FileWriter fw = new FileWriter(this.propertiesFile);
        BufferedWriter bw = new BufferedWriter(fw);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String userName;
                String trimmed = line.trim();
                if (trimmed.startsWith("#")) {
                    bw.append(line);
                    bw.newLine();
                    continue;
                }
                if (trimmed.length() == 0) {
                    bw.newLine();
                    continue;
                }
                int equals = trimmed.indexOf(61);
                if (equals <= 0 || !toSave.contains(userName = trimmed.substring(0, equals))) continue;
                bw.append(userName + "=" + toSave.getProperty(userName));
                bw.newLine();
                toSave.remove(userName);
            }
            for (Object currentKey : toSave.keySet()) {
                bw.append(currentKey + "=" + toSave.getProperty((String)currentKey));
                bw.newLine();
            }
            bw.newLine();
        }
        finally {
            this.safeClose(bw);
            this.safeClose(fw);
            this.safeClose(br);
            this.safeClose(fr);
        }
    }

    private void safeClose(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkWeakPasswords(Properties properties) {
        String admin = "admin";
        if (properties.contains("admin") && "admin".equals(properties.get("admin"))) {
            DomainManagementLogger.ROOT_LOGGER.userAndPasswordWarning();
        }
    }

    public void stop(StopContext context) {
        this.userProperties.clear();
        this.userProperties = null;
        this.propertiesFile = null;
    }

    public DomainCallbackHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }

    @Override
    public Class[] getSupportedCallbacks() {
        return this.supportedCallbacks;
    }

    @Override
    public boolean isReady() {
        Properties users;
        try {
            users = this.getUsersProperties();
        }
        catch (IOException e) {
            return false;
        }
        return users.size() > 0;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
        String userName = null;
        boolean userFound = false;
        Properties users = this.getUsersProperties();
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                userName = nameCallback.getDefaultName();
                userFound = users.containsKey(userName);
                continue;
            }
            if (current instanceof PasswordCallback && this.plainText) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof DigestHashCallback && !this.plainText) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realm = ((RealmCallback)current).getDefaultText();
                if (this.realm.equals(realm)) continue;
                throw DomainManagementMessages.MESSAGES.invalidRealm(realm, this.realm);
            }
            throw new UnsupportedCallbackException(current);
        }
        for (Callback current : toRespondTo) {
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                continue;
            }
            if (current instanceof PasswordCallback) {
                if (!userFound) {
                    throw new UserNotFoundException(userName);
                }
                String password = users.get(userName).toString();
                ((PasswordCallback)current).setPassword(password.toCharArray());
                continue;
            }
            if (!(current instanceof DigestHashCallback)) continue;
            if (!userFound) {
                throw new UserNotFoundException(userName);
            }
            String hash = users.get(userName).toString();
            ((DigestHashCallback)current).setHexHash(hash);
        }
    }
}

