/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;
import org.jboss.as.domain.management.security.state.ValidateUserState;

public class PromptNewUserState
implements State {
    private final StateValues stateValues;
    private ConsoleWrapper theConsole;

    public PromptNewUserState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (stateValues != null && !stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        ValidateUserState continuingState = new ValidateUserState(this.theConsole, this.stateValues);
        if (!this.stateValues.isSilentOrNonInteractive()) {
            this.stateValues.setPassword(null);
            String existingUsername = this.stateValues.getUserName();
            String usernamePrompt = existingUsername == null ? DomainManagementMessages.MESSAGES.usernamePrompt() : DomainManagementMessages.MESSAGES.usernamePrompt(existingUsername);
            this.theConsole.printf(usernamePrompt, new Object[0]);
            String temp = this.theConsole.readLine(" : ", new Object[0]);
            if (temp != null && temp.length() > 0) {
                existingUsername = temp;
            }
            if (temp == null || existingUsername == null || existingUsername.length() == 0) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.noUsernameExiting());
            }
            this.stateValues.setUserName(existingUsername);
        }
        return continuingState;
    }
}

