/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.deployment;

/**
 * An immutable, type-safe object attachment key.  Such a key has no value outside of its object identity.
 *
 * @param <T> the attachment type
 */
public final class AttachmentKey<T> {

    private final Class<T> valueClass;

    /**
     * Construct a new instance.
     *
     * @param valueClass the attachment value class
     */
    public AttachmentKey(final Class<T> valueClass) {
        this.valueClass = valueClass;
    }

    /**
     * Get the value class for this attachment key.
     *
     * @return the value class
     */
    public Class<T> getValueClass() {
        return valueClass;
    }

    /**
     * Construct a new instance.
     *
     * @param valueClass the value class
     * @param <T> the attachment type
     * @return the new instance
     */
    public static <T> AttachmentKey<T> create(final Class<T> valueClass) {
        return new AttachmentKey<T>(valueClass);
    }
}
