/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.chain;

import org.jboss.as.deployment.chain.DeploymentChain;
import org.jboss.as.deployment.chain.DeploymentChainProvider;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.Value;

public class DeploymentChainProviderInjector<T extends DeploymentChain>
implements Injector<DeploymentChainProvider> {
    private final Value<T> deploymentChainValue;
    private final long priority;
    private final DeploymentChainProvider.Selector selector;
    private DeploymentChainProvider deploymentChainProvider;

    public DeploymentChainProviderInjector(Value<T> deploymentChainValue, DeploymentChainProvider.Selector selector, long priority) {
        this.deploymentChainValue = deploymentChainValue;
        this.priority = priority;
        this.selector = selector;
    }

    public void inject(DeploymentChainProvider deploymentChainProvider) throws InjectionException {
        DeploymentChain deploymentChain = (DeploymentChain)this.deploymentChainValue.getValue();
        deploymentChainProvider.addDeploymentChain(deploymentChain, this.selector, this.priority);
        this.deploymentChainProvider = deploymentChainProvider;
    }

    public void uninject() {
        DeploymentChain deploymentChain = (DeploymentChain)this.deploymentChainValue.getValue();
        if (this.deploymentChainProvider != null) {
            this.deploymentChainProvider.removeDeploymentChain(deploymentChain, this.selector, this.priority);
            this.deploymentChainProvider = null;
        }
    }
}

