/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.module;

import java.util.jar.Manifest;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.ManifestAttachment;
import org.jboss.as.deployment.module.ModuleConfig;
import org.jboss.as.deployment.module.ModuleDependencies;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.modules.ModuleIdentifier;

public class ModuleDependencyProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.MODULE_DEPENDENCIES.plus(100L);

    @Override
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        String[] dependencyDefs;
        Manifest manifest = ManifestAttachment.getManifestAttachment(context);
        if (manifest == null) {
            return;
        }
        String dependencyString = manifest.getMainAttributes().getValue("Dependencies");
        if (dependencyString == null) {
            return;
        }
        for (String dependencyDef : dependencyDefs = dependencyString.split(",")) {
            String[] dependencyParts = dependencyDef.split(" ");
            int dependencyPartsLength = dependencyParts.length;
            if (dependencyPartsLength == 0) {
                throw new RuntimeException("Invalid dependency: " + dependencyString);
            }
            ModuleIdentifier dependencyId = ModuleIdentifier.fromString((String)dependencyParts[0]);
            boolean export = this.parseOptionalExportParams(dependencyParts, "export");
            boolean optional = this.parseOptionalExportParams(dependencyParts, "optional");
            ModuleConfig.Dependency dependency = new ModuleConfig.Dependency(dependencyId, true, optional, export);
            ModuleDependencies.addDependency(context, dependency);
        }
    }

    private boolean parseOptionalExportParams(String[] parts, String expected) {
        String part;
        if (parts.length > 1 && expected.equals(part = parts[1])) {
            return true;
        }
        return parts.length > 2 && expected.equals(part = parts[2]);
    }
}

