/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.naming;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.as.deployment.naming.JndiName;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ContextService
implements Service<Context> {
    private final InjectedValue<Context> parentContextValue = new InjectedValue();
    private final JndiName name;
    private Context context;

    public ContextService(JndiName name) {
        this.name = name;
    }

    public synchronized void start(StartContext context) throws StartException {
        Context parentContext = (Context)this.parentContextValue.getValue();
        try {
            this.context = parentContext.createSubcontext(this.name.getLocalName());
        }
        catch (NamingException e) {
            throw new StartException("Failed to create sub-context with name '" + this.name + "' in context '" + parentContext + "'", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        Context parentContext = (Context)this.parentContextValue.getValue();
        try {
            parentContext.destroySubcontext(this.name.getLocalName());
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed to destroy sub-context with name '" + this.name + "' from context '" + parentContext + "'", e);
        }
    }

    public synchronized Context getValue() throws IllegalStateException {
        return this.context;
    }

    public Injector<Context> getParentContextInjector() {
        return this.parentContextValue;
    }
}

