/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.naming;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.as.deployment.naming.ContextNames;
import org.jboss.as.deployment.naming.JndiName;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class ResourceBinder<T>
implements Service<Object> {
    public static final ServiceName JAVA_BINDER = ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"binder"});
    public static final ServiceName APPLICATION_BINDER = ContextNames.APPLICATION_CONTEXT_SERVICE_NAME.append(new String[]{"binder"});
    public static final ServiceName MODULE_BINDER = ContextNames.MODULE_CONTEXT_SERVICE_NAME.append(new String[]{"binder"});
    public static final ServiceName COMPONENT_BINDER = ContextNames.COMPONENT_CONTEXT_SERVICE_NAME.append(new String[]{"binder"});
    private final InjectedValue<Context> namingContextValue = new InjectedValue();
    private final JndiName name;
    private final Value<T> value;

    public ResourceBinder(JndiName name, Value<T> value) {
        this.name = name;
        this.value = value;
    }

    public synchronized void start(StartContext context) throws StartException {
        Context namingContext = (Context)this.namingContextValue.getValue();
        try {
            namingContext.rebind(this.name.getLocalName(), this.value.getValue());
        }
        catch (NamingException e) {
            throw new StartException("Failed to bind resource into context [" + namingContext + "] at location [" + this.name + "]", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        Context namingContext = (Context)this.namingContextValue.getValue();
        try {
            namingContext.unbind(this.name.getLocalName());
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to unbind resource from context [" + namingContext + "] at location [" + this.name + "]", e);
        }
    }

    public synchronized Object getValue() throws IllegalStateException {
        Context namingContext = (Context)this.namingContextValue.getValue();
        try {
            return namingContext.lookup(this.name.getLocalName());
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup value from context [" + namingContext + "] at location [" + this.name + "]", e);
        }
    }

    public Injector<Context> getContextInjector() {
        return this.namingContextValue;
    }
}

