/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.processor;

import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.module.ModuleConfig;
import org.jboss.as.deployment.module.ModuleDependencies;
import org.jboss.as.deployment.processor.ServiceActivatorMarker;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.vfs.VirtualFile;

public class ServiceActivatorDependencyProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(300L);
    private static final String SERVICE_ACTIVATOR_PATH = "META-INF/services/" + ServiceActivator.class.getName();
    private static final ModuleConfig.Dependency MSC_DEP = new ModuleConfig.Dependency(ModuleIdentifier.create((String)"org.jboss.msc"), true, false, false);

    @Override
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment(context);
        if (deploymentRoot == null) {
            return;
        }
        if (deploymentRoot.getChild(SERVICE_ACTIVATOR_PATH).exists()) {
            context.putAttachment(ServiceActivatorMarker.ATTACHMENT_KEY, new ServiceActivatorMarker());
            ModuleDependencies.addDependency(context, MSC_DEP);
        }
    }
}

