/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.scanner;

import java.util.concurrent.TimeUnit;
import org.jboss.as.deployment.scanner.DeploymentScanner;
import org.jboss.as.deployment.scanner.DeploymentScannerFactory;
import org.jboss.as.services.path.AbsolutePathService;
import org.jboss.as.services.path.RelativePathService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DeploymentScannerService
implements Service<DeploymentScanner> {
    private long interval;
    private TimeUnit unit = TimeUnit.MILLISECONDS;
    private boolean enabled;
    private DeploymentScanner scanner;
    private final InjectedValue<String> pathValue = new InjectedValue();
    private final InjectedValue<DeploymentScannerFactory> scannerFactory = new InjectedValue();

    public static ServiceName getServiceName(String repositoryName) {
        return DeploymentScanner.BASE_SERVICE_NAME.append(new String[]{repositoryName});
    }

    public static BatchServiceBuilder<DeploymentScanner> addService(BatchBuilder batchBuilder, String name, String relativeTo, String path, int scanInterval, TimeUnit unit, boolean scanEnabled) {
        DeploymentScannerService service = new DeploymentScannerService(scanInterval, unit, scanEnabled);
        ServiceName serviceName = DeploymentScannerService.getServiceName(name);
        ServiceName pathService = serviceName.append(new String[]{"path"});
        if (relativeTo != null) {
            RelativePathService.addService(pathService, path, relativeTo, batchBuilder);
        } else {
            AbsolutePathService.addService(pathService, path, batchBuilder);
        }
        return batchBuilder.addService(serviceName, (Service)service).addDependency(pathService, String.class, service.pathValue).addDependency(DeploymentScannerFactory.SERVICE_NAME, DeploymentScannerFactory.class, service.scannerFactory).setInitialMode(ServiceController.Mode.ACTIVE);
    }

    DeploymentScannerService(long interval, TimeUnit unit, boolean enabled) {
        this.interval = interval;
        this.unit = unit;
        this.enabled = enabled;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            String pathName = (String)this.pathValue.getValue();
            DeploymentScannerFactory factory = (DeploymentScannerFactory)this.scannerFactory.getValue();
            DeploymentScanner scanner = factory.create(pathName, this.unit.toMillis(this.interval));
            if (this.enabled) {
                scanner.startScanner();
            }
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        DeploymentScanner scanner = this.scanner;
        this.scanner = null;
        scanner.stopScanner();
    }

    public synchronized DeploymentScanner getValue() throws IllegalStateException {
        DeploymentScanner scanner = this.scanner;
        if (scanner == null) {
            throw new IllegalStateException();
        }
        return scanner;
    }
}

