/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.DomainExtensionRemove;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerExtensionAdd;
import org.jboss.as.model.UpdateFailedException;

public final class DomainExtensionAdd
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = 3718982114819320314L;
    private final String moduleName;

    public DomainExtensionAdd(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        if (!element.addExtension(this.moduleName)) {
            throw new UpdateFailedException("Extension " + this.moduleName + " already configured");
        }
    }

    public DomainExtensionRemove getCompensatingUpdate(DomainModel original) {
        if (original.getExtensions().contains(this.moduleName)) {
            return null;
        }
        return new DomainExtensionRemove(this.moduleName);
    }

    public ServerExtensionAdd getServerModelUpdate() {
        return new ServerExtensionAdd(this.moduleName);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return hostModel.getActiveServerNames();
    }
}

