/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainProfileIncludeAdd;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ProfileElement;
import org.jboss.as.model.UpdateFailedException;

public final class DomainProfileIncludeRemove
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String profileName;
    private final String includedProfileName;

    public DomainProfileIncludeRemove(String profileName, String includedProfileName) {
        this.profileName = profileName;
        this.includedProfileName = includedProfileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getIncludedProfileName() {
        return this.includedProfileName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        ProfileElement pe = element.getProfile(this.profileName);
        if (pe == null) {
            throw new UpdateFailedException("Profile '" + this.profileName + "' does not exist");
        }
        if (!pe.removeIncludedProfile(this.includedProfileName)) {
            throw new UpdateFailedException("Profile '" + this.profileName + "' does not include profile '" + this.includedProfileName + "'");
        }
    }

    public DomainProfileIncludeAdd getCompensatingUpdate(DomainModel original) {
        return new DomainProfileIncludeAdd(this.profileName, this.includedProfileName);
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

