/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainProfileAdd;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ProfileElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.UpdateFailedException;

public final class DomainProfileRemove
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String profileName;

    public DomainProfileRemove(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        ProfileElement pe = element.getProfile(this.profileName);
        if (pe != null && (pe.getIncludedProfiles().size() > 0 || pe.getSubsystems().size() > 0)) {
            throw new UpdateFailedException("Profile '" + this.profileName + "' is not empty and cannot be removed");
        }
        StringBuilder illegal = null;
        for (String serverGroupName : element.getServerGroupNames()) {
            ServerGroupElement sge = element.getServerGroup(serverGroupName);
            if (!this.profileName.equals(sge.getName())) continue;
            if (illegal == null) {
                illegal = new StringBuilder(sge.getName());
                continue;
            }
            illegal.append(", ");
            illegal.append(sge.getName());
        }
        if (illegal != null) {
            throw new UpdateFailedException(String.format("Profile %s cannot be removed as it is still used by server groups %s", this.profileName, illegal.toString()));
        }
        element.removeProfile(this.profileName);
    }

    public DomainProfileAdd getCompensatingUpdate(DomainModel original) {
        return new DomainProfileAdd(this.profileName);
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

