/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.AbstractSocketBindingUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerSocketBindingUpdate;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.SocketBindingGroupElement;

public class DomainSocketBindingUpdate
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = 1L;
    private final String socketGroupName;
    private final AbstractSocketBindingUpdate update;

    public DomainSocketBindingUpdate(String socketGroupName, AbstractSocketBindingUpdate udpate) {
        this.socketGroupName = socketGroupName;
        this.update = udpate;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        SocketBindingGroupElement group = element.getSocketBindingGroup(this.socketGroupName);
        if (group == null) {
            throw new UpdateFailedException("no such socket-binding group " + this.socketGroupName);
        }
        this.update.applyUpdate(group);
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel original) {
        SocketBindingGroupElement group = original.getSocketBindingGroup(this.socketGroupName);
        return new DomainSocketBindingUpdate(this.socketGroupName, this.update.getCompensatingUpdate(group));
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerSocketBindingUpdate(this.update);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        ArrayList<String> result = new ArrayList<String>();
        for (String serverName : hostModel.getActiveServerNames()) {
            ServerElement server = hostModel.getServer(serverName);
            if (!this.socketGroupName.equals(server.getSocketBindingGroupName()) && !this.socketGroupName.equals(domainModel.getServerGroup(server.getServerGroup()).getSocketBindingGroupName())) continue;
            result.add(serverName);
        }
        return result;
    }
}

