/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainSubsystemRemove;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerSubsystemAdd;
import org.jboss.as.model.UpdateFailedException;

public final class DomainSubsystemAdd
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String profileName;
    private final AbstractSubsystemAdd<?> subsystemAdd;

    public DomainSubsystemAdd(String profileName, AbstractSubsystemAdd<?> subsystemAdd) {
        this.profileName = profileName;
        this.subsystemAdd = subsystemAdd;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getNamespaceUri() {
        return this.subsystemAdd.getNamespaceUri();
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        String namespaceUri = this.subsystemAdd.getNamespaceUri();
        if (!element.getProfile(this.profileName).addSubsystem(namespaceUri, (AbstractSubsystemElement<?>)this.subsystemAdd.createSubsystemElement())) {
            throw new UpdateFailedException("Subsystem '" + namespaceUri + "' is already configured in profile '" + this.profileName + "'");
        }
    }

    public DomainSubsystemRemove getCompensatingUpdate(DomainModel original) {
        return new DomainSubsystemRemove(this.profileName, this.subsystemAdd.getCompensatingUpdate(original.getProfile(this.profileName)));
    }

    public ServerSubsystemAdd getServerModelUpdate() {
        return new ServerSubsystemAdd(this.subsystemAdd);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        if (this.getServerModelUpdate() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String server : hostModel.getActiveServerNames()) {
            String serverGroupName = hostModel.getServer(server).getServerGroup();
            if (!this.profileName.equals(domainModel.getServerGroup(serverGroupName).getProfileName())) continue;
            result.add(server);
        }
        return result;
    }
}

